//
// Created by lhs on 20-6-5.
//
#include <jni.h>
#include <android/log.h>

#define LOG_TAG "LHS_EDUBOX_JNI"
#define LOGE(...) __android_log_print(ANDROID_LOG_ERROR,LOG_TAG,__VA_ARGS__)

jbyte bit_reverse(jbyte bitmap, jint bitPosion){

    LOGE("bit_reverse start posion %d , bitmap is %d" ,bitPosion, bitmap);
    jbyte tmp = bitmap;
    switch (bitPosion) {
        case 0:
            tmp = bitmap|1;
            break;
        case 1:
            tmp = bitmap|2;
            break;
        case 2:
            tmp = bitmap|4;
            break;
        case 3:
            tmp = bitmap|8;
            break;
        case 4:
            tmp = bitmap|16;
            break;
        case 5:
            tmp = bitmap|32;
            break;
        case 6:
            tmp = bitmap|64;
            break;
        case 7:
            tmp = bitmap|128;
            break;
        default:
            LOGE("bit_reverse invalid posion %d" ,bitPosion);
    }
    LOGE("bit_reverse start tmp %d" ,tmp);
    return tmp;
}

JNIEXPORT jint JNICALL
Java_com_beanpodtech_eduboxclient_jni_CounterNative_testjni(JNIEnv *env, jclass type) {

    LOGE("testjn start");
    int ret = 0;//se_finalize_channel();
    LOGE("testjn finish: 0x%x", ret);

    return ret;
}

JNIEXPORT jbyte JNICALL
Java_com_beanpodtech_eduboxclient_jni_CounterNative_bitRevese(JNIEnv *env, jclass clazz,
        jbyte currentBitmap ,jint posion) {
    // TODO: implement bitRevese()
    LOGE("bitRevese start");
    jbyte tmp = currentBitmap;
    int bitPosion = 0;
    bitPosion = posion % 8;
    if (currentBitmap != 255) {
          tmp = bit_reverse(currentBitmap, bitPosion);
    }
    LOGE("bitRevese finish: 0x%x", tmp);
    return tmp;
}

JNIEXPORT jint JNICALL
Java_com_beanpodtech_eduboxclient_jni_CounterNative_bitmapRevese(JNIEnv *env, jclass clazz,
                                                                 jbyteArray bitmap, jint posion) {
    // TODO: implement bitmapRevese()
    LOGE("bitRevese start");
    jbyte *tmpByteArray;
    int index = 0;
    int bitPosion = 0;
    int ret = 0;//0 need count, 1 do nothing
    jbyte tmpbyte = 0;
    index = posion / 8;
    bitPosion = posion % 8;
    //get the byte
    tmpByteArray = (*env)->GetByteArrayElements(env, bitmap, NULL);
    if (tmpByteArray == NULL) {
        return ret; /* exception occurred */
    }
    tmpbyte = tmpByteArray[index];
    if (tmpbyte == 255) {
        ret = 1;
        goto RELEASE1;
    } else if (tmpbyte == 0) {
        jbyte tmp_reverse = bit_reverse(tmpbyte, bitPosion);
        if (tmp_reverse == tmpbyte) {
            ret = 1;
        }
        tmpByteArray[index] = tmp_reverse;
    }
RELEASE1:
    (*env)->ReleaseByteArrayElements(env, bitmap, tmpByteArray, 0);
    LOGE("bitRevese finish: 0x%x", ret);
    return ret;
}

JNIEXPORT jbyteArray JNICALL
Java_com_beanpodtech_eduboxclient_jni_CounterNative_bitmapOROperation(JNIEnv *env, jclass clazz,
                                                                      jbyteArray bitmap_dest,
                                                                      jbyteArray bitmap,
                                                                      jint length) {
    // TODO: implement bitmapOROperation()

    jbyte *tmp_bimap_dest;
    jbyte *tmp_bitmap;
    //get the byte
    tmp_bimap_dest = (*env)->GetByteArrayElements(env, bitmap_dest, NULL);
    if (tmp_bimap_dest == NULL) {
        return NULL; /* exception occurred */
    }
    tmp_bitmap = (*env)->GetByteArrayElements(env, bitmap, NULL);
    if (tmp_bitmap == NULL) {
        return NULL; /* exception occurred */
    }
    for (int i = 0; i < length; i++) {
        tmp_bimap_dest[i] = tmp_bimap_dest[i] | tmp_bitmap[i];
        //LOGE("tmp_bimap_dest[%d] = %d",i,tmp_bimap_dest[i]);
    }
    RELEASE1:
    (*env)->ReleaseByteArrayElements(env, bitmap_dest, tmp_bimap_dest, 0);
    (*env)->ReleaseByteArrayElements(env, bitmap, tmp_bitmap, 0);
    LOGE("bitmapOROperation finish");
    return  bitmap_dest;
}