package com.beanpodtech.allinone.activity;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.ChangePassword;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.utils.BoxUtil;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.OkGoUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.model.Response;

import org.json.JSONException;
import org.json.JSONObject;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import okhttp3.MediaType;
import okhttp3.RequestBody;

public class ChangePasswordActivity extends BaseActivity {
    private String oldpassword_MD5;
    private String newpassword_MD5;

    @Override
    public void widgetClick(View v) {

    }


    @Override
    public int bindLayout() {
        return R.layout.activity_change_password;
    }

    @Override
    public void initView(View view) {
        click();
    }

    @Override
    public void initListener() {

    }

    @Override
    public void initData(Context mContext) {

    }

    private void click() {
        Button change = findViewById(R.id.changeButton);
        change.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                String oldPassword = ((EditText) findViewById(R.id.oldPassword)).getText().toString();
                String newPassword = ((EditText) findViewById(R.id.newPassword)).getText().toString();
                String againPassword = ((EditText) findViewById(R.id.againPassword)).getText().toString();
                if (oldPassword.length() == 0) {
                    Toast.makeText(ChangePasswordActivity.this, "请输入原始密码", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (newPassword.length() == 0) {
                    Toast.makeText(ChangePasswordActivity.this, "请输入新密码", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (againPassword.length() == 0) {
                    Toast.makeText(ChangePasswordActivity.this, "没有输入确认新密码", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (oldPassword.equals(newPassword) == true) {
                    Toast.makeText(ChangePasswordActivity.this, "原始密码和新密码不能相同", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (againPassword.equals(newPassword) == false) {
                    Toast.makeText(ChangePasswordActivity.this, "两次输入的密码不一致", Toast.LENGTH_SHORT).show();
                    return;
                }
                if (oldPassword.length() != 0 && newPassword.length() != 0 && againPassword.length() != 0) {
                    try {
                        oldpassword_MD5 = getMD5(oldPassword);
                        newpassword_MD5 = getMD5(newPassword);
                    } catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                    String userName = SpUtil.getInstace().getString(Contants.USER_NAME, null);
                    String userId = SpUtil.getInstace().getString(Contants.USER_ID, null);
                    String boxId = BoxUtil.getDeviceSN();
                    RequestBody requestBody = RequestBody.create(MediaType.parse("application/json;charset=utf-8"), initJson(userName, userId, boxId, oldpassword_MD5, newpassword_MD5));
                    OkGo.<ChangePassword>post(UrlConfig.CHANGE_PASSWORD).upRequestBody(requestBody).execute(new OkGoUtil<ChangePassword>(ChangePassword.class) {
                        @Override
                        public void onSuccess(Response<ChangePassword> response) {
                            ChangePassword body = response.body();
                            if (body.getstatus() == 0) {
                                Toast.makeText(ChangePasswordActivity.this, "密码修改成功", Toast.LENGTH_SHORT).show();
                                finish();
                            } else if (body.getstatus() == -1) {
                                AlertDialog alertDialog = new AlertDialog.Builder(ChangePasswordActivity.this)
                                        .setMessage("该账号在其他设备上登录,请重新登录")
                                        .setPositiveButton("确定", new DialogInterface.OnClickListener() {//添加"Yes"按钮
                                            @Override
                                            public void onClick(DialogInterface dialogInterface, int i) {
                                                SpUtil.getInstace().clear();
                                                finish();
                                            }
                                        })
                                        .create();
                                alertDialog.show();
                            } else if (body.getstatus() == -2) {
                                Toast.makeText(ChangePasswordActivity.this, "密码错误", Toast.LENGTH_SHORT).show();
                            }
                        }
                    });
                }

            }
        });
    }

    public static String getMD5(String val) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(val.getBytes());
        byte[] bytearray = md5.digest();// 加密
        StringBuffer sb = new StringBuffer();
        for (byte b : bytearray) {
            int i = (b & 0xFF);
            if (i < 0x10) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(i));
        }
        return sb.toString();
    }

    private String initJson(String userName, String userId, String boxId, String oldPassWord, String newPassWord) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("userId", userId);
            jsonObject.put("boxId", boxId);
            jsonObject.put("userName", userName);
            jsonObject.put("oldPassword", oldPassWord);
            jsonObject.put("newPassword", newPassWord);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }
}
