package com.beanpodtech.allinone.activity;


import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.fragment.ClassTypeFragment;
import com.beanpodtech.allinone.fragment.FindFragment;
import com.beanpodtech.allinone.fragment.FirstFragment;
import com.beanpodtech.allinone.fragment.MineFragment;

import java.util.Calendar;

/**
 * 首页
 **/
public class HomeActivity extends BaseActivity {
    private FirstFragment mHomeFragment = new FirstFragment();
    private ClassTypeFragment mClassFragment = new ClassTypeFragment();
    private MineFragment mMineFragment = new MineFragment();
    private FindFragment mFindFragment = new FindFragment();
    private RadioButton mRbtHome, mRbtClass, mRbtFind, mRbtMine;
    TextView data, time, week;
    String mWay;
    boolean timeThreadState = false;
    private boolean isHomeFragment = true;
    private ImageView settingIv, wifiIv; //右上角的设置 和wifi按钮

    @Override
    public int bindLayout() {
        return R.layout.activity_home;
    }

    @Override
    public void initView(View view) {
        data = view.findViewById(R.id.date);
        time = view.findViewById(R.id.time);
        week = view.findViewById(R.id.week);
        settingIv = view.findViewById(R.id.iv_setting);
        wifiIv = view.findViewById(R.id.iv_wifi);
        settingIv.setOnClickListener(click);
        wifiIv.setOnClickListener(click);

        mRbtHome = findViewById(R.id.rbt_home);
        mRbtClass = findViewById(R.id.rbt_class);
        mRbtMine = findViewById(R.id.rbt_mine);
        mRbtFind = findViewById(R.id.rbt_find);
        mRbtHome.setOnClickListener(click);
        mRbtMine.setOnClickListener(click);
        mRbtClass.setOnClickListener(click);
        mRbtFind.setOnClickListener(click);

    }

    @Override
    public void initData(Context mContext) {
        selectedFragment(mHomeFragment);
        timeThreadState = true;
        new TimeThread().start();
    }

    /**
     * replace
     *
     * @param fragment
     */
    public void selectedFragment(Fragment fragment) {
        FragmentManager fm = getSupportFragmentManager();
        FragmentTransaction ft = fm.beginTransaction();
        ft.replace(R.id.fragment, fragment);
        ft.commit();
    }

    /**
     * click点击事件
     * click点击事件
     **/
    View.OnClickListener click = v -> {
        if (v.getId() == R.id.rbt_home) {
            selectedFragment(mHomeFragment);
            isHomeFragment = false;
            return;
        }
        if (v.getId() == R.id.rbt_class) {
            selectedFragment(mClassFragment);
            isHomeFragment = false;
            return;
        }
        if (v.getId() == R.id.rbt_find) {
            selectedFragment(mFindFragment);
            isHomeFragment = false;
            return;
        }
        if (v.getId() == R.id.rbt_mine) {
            selectedFragment(mMineFragment);
            isHomeFragment = false;
            return;
        }

        if (v.getId() == R.id.setting_iv) {
            startActivity(new Intent(Settings.ACTION_ACCESSIBILITY_SETTINGS));
            return;
        }
        if (v.getId() == R.id.iv_wifi) {
            startActivity(new Intent(Settings.ACTION_WIFI_SETTINGS));
            return;
        }

    };

    @Override
    public void widgetClick(View v) {

    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 0x11 && resultCode == 0x11) {
            Intent intent = getIntent();
            finish();
            startActivity(intent);
        }
    }


    class TimeThread extends Thread {
        @Override
        public void run() {
            do {
                try {
                    Thread.sleep(500);
                    Message msg = new Message();
                    msg.what = 1;  //消息(一个整型值)
                    mHandler.sendMessage(msg);// 每隔1秒发送一个msg给mHandler
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (timeThreadState);
        }
    }

    @Override
    public void initListener() {
        /**
         * homeFragment的回调
         **/
//        mHomeFragment.setOnButtonClick(view -> {
//            selectedFragment(mClassFragment);
//            mRbtClass.setChecked(true);
//            isHomeFragment = false;
//
//        });
    }

    private Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1:
                    long sysTime = System.currentTimeMillis();//获取系统时间
                    CharSequence sysDataStr = DateFormat.format("yyyy年MM月dd日", sysTime);//时间显示格式
                    CharSequence sysTimeStr = DateFormat.format(" hh:mm:ss", sysTime);//时间显示格式
                    data.setText(sysDataStr); //更新时间
                    time.setText(sysTimeStr);
                    final Calendar c = Calendar.getInstance();
                    mWay = String.valueOf(c.get(Calendar.DAY_OF_WEEK));
                    if ("1".equals(mWay)) {
                        mWay = "天";
                    } else if ("2".equals(mWay)) {
                        mWay = "一";
                    } else if ("3".equals(mWay)) {
                        mWay = "二";
                    } else if ("4".equals(mWay)) {
                        mWay = "三";
                    } else if ("5".equals(mWay)) {
                        mWay = "四";
                    } else if ("6".equals(mWay)) {
                        mWay = "五";
                    } else if ("7".equals(mWay)) {
                        mWay = "六";
                    }
                    week.setText("星期" + mWay);
                    break;
                default:
                    break;

            }
        }
    };


    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onStop() {
        super.onStop();
        timeThreadState = false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK && !isHomeFragment) {
            selectedFragment(mHomeFragment);
            isHomeFragment = true;
            mRbtHome.setChecked(true);
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

}
