package com.beanpodtech.allinone.activity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.AllClassdisplay;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.HttpUtils;
import com.beanpodtech.allinone.utils.OkGoBuilder;
import com.beanpodtech.allinone.utils.OkGoUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.bumptech.glide.Glide;
import com.lzy.okgo.model.Response;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import okhttp3.RequestBody;

public class IncreasedclassActivity extends BaseActivity {
    private RecyclerView mRecyclerView1;
    private RecyclerView mRecyclerView2;
    private RecyclerView mRecyclerView3;
    private ImageView increase;
    String userId = SpUtil.getInstace().getString(Contants.USER_ID, null);
    HashMap<String, String> map = new HashMap<>();
    private List<AllClassdisplay.ListBean> data1;
    OneIncreaseAdapter oneIncreaseAdapter;
    TwoIncreaseAdapter twoIncreaseAdapter;
    ThreeIncreaseAdapter threeIncreaseAdapter;
    AllClassdisplay.ListBean data=new AllClassdisplay.ListBean();
    List<AllClassdisplay.ListBean> addlist;

    @Override
    public void widgetClick(View v) {

    }


    @Override
    public int bindLayout() {
        return R.layout.activity_increasedclass;
    }

    @Override
    public void initView(View view) {
        data1= (List<AllClassdisplay.ListBean>) getIntent().getSerializableExtra("list");
        if (data1==null){
            data1=new ArrayList<>();
        }
        increase=findViewById(R.id.increase);
        ImageView back=findViewById(R.id.iv_back);
        back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });
        mRecyclerView2=findViewById(R.id.increase_recyclerview2);
        mRecyclerView2.setAdapter(twoIncreaseAdapter = new TwoIncreaseAdapter());
        map.put("userId", userId);
        final RequestBody body = HttpUtils.getRequestJson(map);
        OkGoBuilder.getInstance().url(UrlConfig.ALLCLASSDISPLAY).method(OkGoBuilder.PSOT).cls(AllClassdisplay.class).
                Builder(IncreasedclassActivity.this).requestBody(body).callback(new OkGoUtil<AllClassdisplay>(AllClassdisplay.class) {
            @Override
            public void onSuccess(Response<AllClassdisplay> response) {
                AllClassdisplay body = response.body();
                addlist = body.getList();
                int i,j;
                if(data1!=null&&data1.size()>0){
                    for(i=0;i<addlist.size();i++){
                        for(j=0;j<data1.size();j++){
                            if(addlist.get(i).getClassId().equals(data1.get(j).getClassId())){
                              addlist.remove(i);
                              i --;
                              break;
                            }
                        }
                    }
                }
                mRecyclerView2.setLayoutManager(new StaggeredGridLayoutManager(7,
                        StaggeredGridLayoutManager.VERTICAL));
                mRecyclerView2.setItemAnimator(new DefaultItemAnimator());
            }

        }).build();
    }
private String getRequestBody(){
    JSONObject jsonObject=null;
    try {
        jsonObject =new JSONObject();
    JSONArray jsonArray=new JSONArray();
    JSONObject object=null;
        for (int i=0;i<data1.size();i++){
            object=new JSONObject();

                object.put("classId",data1.get(i).getClassId());

            jsonArray.put(object);
        }
        jsonObject.put("list",jsonArray);

    } catch (JSONException e) {
        e.printStackTrace();
    }
    return jsonObject.toString();
}
    @Override
    public void initListener() {
        increase.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                getRequestBody();
                map.put("userId", userId);
                map.put("classId", getRequestBody());
                final RequestBody body1 = HttpUtils.getRequestJson(map);
                OkGoBuilder.getInstance().url(UrlConfig.ADDCLASSDISPLAY).method(OkGoBuilder.PSOT).cls(AllClassdisplay.class).
                        Builder(IncreasedclassActivity.this).requestBody(body1).callback(new OkGoUtil<AllClassdisplay>(AllClassdisplay.class) {
                    @Override
                    public void onSuccess(Response<AllClassdisplay> response) {
                        finish();
                    }
                }).build();


            }
        });
    }
    @Override
    public void initData(Context mContext) {
        mRecyclerView1=findViewById(R.id.increase_recyclerview1);

        mRecyclerView3=findViewById(R.id.increase_recyclerview3);
        mRecyclerView3.setAdapter(threeIncreaseAdapter = new ThreeIncreaseAdapter());
        mRecyclerView3.setLayoutManager(new StaggeredGridLayoutManager(1,
                StaggeredGridLayoutManager.HORIZONTAL));
        mRecyclerView3.setItemAnimator(new DefaultItemAnimator());

        mRecyclerView1.setAdapter(oneIncreaseAdapter = new OneIncreaseAdapter());
        mRecyclerView1.setLayoutManager(new StaggeredGridLayoutManager(1,
                StaggeredGridLayoutManager.HORIZONTAL));
        mRecyclerView1.setItemAnimator(new DefaultItemAnimator());

    }


    public class OneIncreaseAdapter extends RecyclerView.Adapter {


        @RequiresApi(api = Build.VERSION_CODES.M)
        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            @SuppressLint("ResourceType")
            View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.item_addincrease,parent,false);
            ViewHolder holder = new ViewHolder(view);
            return holder;
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
            Glide.with(IncreasedclassActivity.this).load(data1.get(position).getUrl()).into(((ViewHolder) holder).imageView);
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if(data1==null||data1.size()>0){
                        data=new AllClassdisplay.ListBean();
                        data.setClassId(data1.get(position).getClassId());
                        data.setUrl(data1.get(position).getUrl());
                        addlist.add(data);
                        data1.remove(position);
                        twoIncreaseAdapter.addData(addlist.size());
                        notifyItemRemoved(position);
                        notifyDataSetChanged();
                    }
                }
            });
        }
        public void addData(int position) {
            //添加动画
            notifyItemInserted(position);
        }
        @Override
        public int getItemCount() {
            if(data1==null){
                return 0;
            }
            return data1.size();


        }
        public class ViewHolder extends RecyclerView.ViewHolder {
            TextView textView;
            ImageView imageView;
            public ViewHolder(@NonNull View itemView) {
                super(itemView);

                imageView=itemView.findViewById(R.id.imageview);
            }
        }
    }
    public class TwoIncreaseAdapter extends RecyclerView.Adapter {

        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.item_allincrease,parent,false);
            ViewHolder holder=new ViewHolder(view);
            return holder;
        }
        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
            Glide.with(IncreasedclassActivity.this).load(addlist.get(position).getUrl()).into(((ViewHolder) holder).imageView);
            holder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    if(data1==null||data1.size()<5){
                        data=new AllClassdisplay.ListBean();
                        data.setClassId(addlist.get(position).getClassId());
                        data.setUrl(addlist.get(position).getUrl());
                        data1.add(data);
                        addlist.remove(position);
                        oneIncreaseAdapter.addData(data1.size());
                        notifyItemRemoved(position);
                        notifyDataSetChanged();
                    }
                }
            });
        }
        public void addData(int position) {
            //添加动画
            notifyItemInserted(position);
        }
        @Override
        public int getItemCount() {
            return addlist.size();
        }
        public class ViewHolder extends RecyclerView.ViewHolder {

            ImageView imageView;
            public ViewHolder(@NonNull View itemView) {
                super(itemView);

                imageView=itemView.findViewById(R.id.imageview);
            }
        }
    }
    public class ThreeIncreaseAdapter extends RecyclerView.Adapter{
        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

            View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.item_background,parent,false);
            ViewHolder holder=new ViewHolder(view);
            return holder;
        }

        @Override
        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

        }

        @Override
        public int getItemCount() {
            return 5;
        }
    }
    public class ViewHolder extends RecyclerView.ViewHolder {
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }
}

