package com.beanpodtech.allinone.activity;

import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.adapter.MyAccountAdapter;
import com.beanpodtech.allinone.bean.MyAccountBean;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.utils.BoxUtil;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.HttpUtils;
import com.beanpodtech.allinone.utils.OkGoBuilder;
import com.beanpodtech.allinone.utils.OkGoUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.lzy.okgo.model.Response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MyAccountActivity extends BaseActivity {
    private Context mContext = this;
    private final static String CLASSTYPE_DATA = "data";
    private ImageView ivBack;
    private TextView tvName;
    private TextView tvSchool;
    private TextView tvPhone;
    private TextView tvBoxId;
    private RecyclerView rcvData;
    private List<MyAccountBean.ListBean> totalList = new ArrayList<>();
    private MyAccountAdapter adapter;
    private PopupWindow popupWindow;

    public static void startActivity(Context context, Bundle bundle) {
        Intent intent = new Intent(context, MyAccountActivity.class);
        intent.putExtra(CLASSTYPE_DATA, bundle);
        context.startActivity(intent);
    }

    @Override
    public void widgetClick(View v) {

    }


    @Override
    public int bindLayout() {
        return R.layout.activity_my_account;
    }

    @Override
    public void initView(View view) {

        ivBack = findViewById(R.id.iv_back);
        tvName = findViewById(R.id.tv_name);
        tvSchool = findViewById(R.id.tv_school);
        tvPhone = findViewById(R.id.tv_phone);
        tvBoxId = findViewById(R.id.tv_boxId);
        rcvData = findViewById(R.id.rcv_data);
//        final LinearLayout viewById = findViewById(R.id.ll_root);
//        ImageView ivGif = findViewById(R.id.iv_gif);
//        Glide.with(this).asGif().load(R.raw.test).into(ivGif);
        rcvData.setLayoutManager(new StaggeredGridLayoutManager(5,
                StaggeredGridLayoutManager.VERTICAL));
        rcvData.setItemAnimator(new DefaultItemAnimator());
//        startActivity(new Intent(this, RtcVideoQaActivity.class));
//        initPopupWindow();
//        findViewById(R.id.btn_1).setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                popupWindow.showAsDropDown(viewById);
//            }
//        });
//        findViewById(R.id.btn_2).setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                popupWindow.dismiss();
//            }
//        });
    }

//    private void initPopupWindow() {
//        View contentView = LayoutInflater.from(this).inflate(R.layout.popupwindow_learning_feedback, null);
//        XWalkView wvData = contentView.findViewById(R.id.wv_data);
//        wvData.loadUrl("https://blog.csdn.net/sky1203850702/article/details/44916819/");
//        popupWindow = new PopupWindow(this);
//        popupWindow.setContentView(contentView);
//        popupWindow.setWidth(400);
//        popupWindow.setHeight(600);
//        popupWindow.setFocusable(true);
//        popupWindow.setBackgroundDrawable(new PaintDrawable());
//    }

    @Override
    public void initListener() {
        ivBack.setOnClickListener(this);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    public void initData(Context mContext) {
        tvName.setText(getResources().getString(R.string.myaccount_name) + SpUtil.getInstace().getString(Contants.USER_NICKNAME, null));
        tvSchool.setText(getResources().getString(R.string.myaccount_school) + SpUtil.getInstace().getString(Contants.USER_SCHOOLNAME, null));
        tvPhone.setText(getResources().getString(R.string.myaccount_phone) + SpUtil.getInstace().getString(Contants.USER_NAME, null));
        tvBoxId.setText(getResources().getString(R.string.myaccount_sn) + BoxUtil.getDeviceSN());
        adapter = new MyAccountAdapter(totalList, mContext);
        rcvData.setAdapter(adapter);
        getDataFromNet();
    }


    private void getDataFromNet() {
        OkGoBuilder.getInstance().url(UrlConfig.GET_MYACCOUNT).RequestId(0).requestBody(HttpUtils.getRequestJson(initRequestBody())).cls(MyAccountBean.class).method(OkGoBuilder.PSOT).Builder(this).callback(new OkGoUtil<MyAccountBean>(MyAccountBean.class) {
            @Override
            public void onSuccess(Response<MyAccountBean> response) {
                MyAccountBean body = response.body();
                totalList.clear();
                if (body != null && body.getList() != null) {
                    totalList.addAll(body.getList());
                }
                adapter.notifyDataSetChanged();
//                popupWindow.showAsDropDown(llRoot);
            }
        }).build();
    }

    private HashMap<String, String> initRequestBody() {
        HashMap<String, String> map = new HashMap<>();
        map.put("userId", SpUtil.getInstace().getString(Contants.USER_ID, null));
//        map.put("boxId", BoxUtil.getDeviceSN());
        return map;
    }
}
