package com.beanpodtech.allinone.activity;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import android.os.Bundle;
import android.util.Log;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.adapter.NativeAppAdapter;
import com.beanpodtech.allinone.entity.AppInfo;
import com.beanpodtech.allinone.utils.GetAppsInfo;

import java.util.ArrayList;
import java.util.List;

public class NativeAppActivity extends AppCompatActivity {

    private static final String TAG = "NativeAppActivity";
    private static final int SPAN_COUNT = 16;

    private GetAppsInfo mAppsInfoUtil;
    private List<AppInfo> mAppInfos = new ArrayList<AppInfo>();
    private RecyclerView mRecyclerView;
    private NativeAppAdapter mAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_native_app);
        mAppsInfoUtil = new GetAppsInfo(this);
        initData();
    }

    protected void initData() {
        mAppInfos = mAppsInfoUtil.getAppList();
        for (int i = 0; mAppInfos != null && i < mAppInfos.size(); i++) {
            Log.d(TAG, "app name is " + mAppInfos.get(i).getAppName());
        }
        mAdapter = new NativeAppAdapter(mAppInfos);
        mRecyclerView = findViewById(R.id.native_app_recyclerview);
        mRecyclerView.setAdapter(mAdapter);
        mRecyclerView.setLayoutManager(new StaggeredGridLayoutManager(SPAN_COUNT,
                StaggeredGridLayoutManager.VERTICAL));
        mRecyclerView.setItemAnimator(new DefaultItemAnimator());
    }
}
