package com.beanpodtech.allinone.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.beanpodtech.allinone.R;
import com.bumptech.glide.Glide;
import com.github.chrisbanes.photoview.PhotoView;

public class PicActivity extends AppCompatActivity {

    private PhotoView photoView;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_pic);

        this.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);

        photoView = findViewById(R.id.photo_view);
        ImageView ivBack = findViewById(R.id.iv_back);


        String url = getIntent().getStringExtra("url");

        Glide.with(PicActivity.this).load(url).error(R.drawable.placeholder_big).into(photoView);

        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }


    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);

        String url = getIntent().getStringExtra("url");

        Glide.with(PicActivity.this).load(url).error(R.drawable.placeholder_big).into(photoView);

    }
}
