package com.beanpodtech.allinone.activity;

import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.adapter.RecommendVideoAdapter;
import com.beanpodtech.allinone.bean.RecommendVideoBean;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.HttpUtils;
import com.beanpodtech.allinone.utils.OkGoBuilder;
import com.beanpodtech.allinone.utils.OkGoUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.jcodecraeer.xrecyclerview.XRecyclerView;
import com.lzy.okgo.model.Response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SearchResultActivity extends BaseActivity {
    private static final String KEYWORD = "keyWord";
    private String keyWord;
    private ImageView ivBack;
    private TextView tv_title;
    private int page = 0;//页码
    private int number = 20;//每页数量
    private List<RecommendVideoBean.ListBean> listRecommend = new ArrayList<>();
    private RecommendVideoAdapter recommendVideoAdapter;
    private String userId;
    private XRecyclerView idRecyclerview;
    private int totalPages;

    public static void startActivity(Context context, String keyWord) {
        Intent intent = new Intent(context, SearchResultActivity.class);
        intent.putExtra(KEYWORD, keyWord);
        context.startActivity(intent);
    }

    @Override
    public void widgetClick(View v) {
        switch (v.getId()) {
            case R.id.iv_back:
                finish();
                break;
        }
    }


    @Override
    public int bindLayout() {
        return R.layout.activity_search_result;
    }

    @Override
    public void initView(View view) {
        ivBack = findViewById(R.id.iv_back);
        tv_title = findViewById(R.id.tv_title);
        tv_title.setText(getResources().getString(R.string.searchresult));
        idRecyclerview = findViewById(R.id.id_recyclerview);
        idRecyclerview.setPullRefreshEnabled(false);
        idRecyclerview.setLayoutManager(new GridLayoutManager(this, 5));
        idRecyclerview.setItemAnimator(new DefaultItemAnimator());
        recommendVideoAdapter = new RecommendVideoAdapter(listRecommend, mContext);
        idRecyclerview.setAdapter(recommendVideoAdapter);
    }

    @Override
    public void initListener() {
        ivBack.setOnClickListener(this);
        idRecyclerview.setLoadingListener(new XRecyclerView.LoadingListener() {
            @Override
            public void onRefresh() {

            }

            @Override
            public void onLoadMore() {
                if (page == totalPages) {
                    Toast.makeText(mContext, R.string.havenot_moredata, Toast.LENGTH_SHORT).show();
                    resetRecycleViewState();

                } else {
                    page++;
                    getRecommendVideo();
                }

            }
        });
    }

    /**
     * 重置RecycleView 刷新状态
     */
    private void resetRecycleViewState() {
        idRecyclerview.refreshComplete();
        idRecyclerview.loadMoreComplete();
    }

    @Override
    public void initData(Context mContext) {
        userId = SpUtil.getInstace().getString(Contants.USER_ID, null);
        keyWord = getIntent().getStringExtra(KEYWORD);
        getRecommendVideo();

    }

    /**
     * 获取推荐课程
     */
    private void getRecommendVideo() {
        OkGoBuilder.getInstance().url(UrlConfig.SEARCHVIDEO).Builder(this).requestBody(HttpUtils.getRequestJson(initRequestJson(userId, keyWord, page + "", number + ""))).cls(RecommendVideoBean.class).method(OkGoBuilder.PSOT).callback(new OkGoUtil<RecommendVideoBean>(RecommendVideoBean.class) {
            @Override
            public void onSuccess(Response<RecommendVideoBean> response) {
                if (response.body() != null && response.body().getList() != null) {
                    if (response.body() instanceof RecommendVideoBean) {
                        RecommendVideoBean body = response.body();
                        totalPages = body.getTotalPages();
                        List<RecommendVideoBean.ListBean> list = body.getList();
//                        listRecommend.clear();
                        listRecommend.addAll(list);
                        recommendVideoAdapter.notifyDataSetChanged();
                        resetRecycleViewState();
                    }
                }/* else {
                    ToastUtils.show(mContext, "网络请求异常");
                }*/

//                progressDialog.dismiss();

            }

            @Override
            public void onError(Response<RecommendVideoBean> response) {
                super.onError(response);
            }

            @Override
            public void onFinish() {
                super.onFinish();

            }
        }).build();
    }

    /**
     * @param userId 用户Id
     * @return 返回处理好的请求requestBody
     */
    private HashMap<String, String> initRequestJson(String userId, String keyWord, String page, String number) {
        HashMap<String, String> map = new HashMap<>();
        map.put("userId", userId);
        map.put("keyWord", keyWord);
        map.put("page", page);
        map.put("number", number);
        return map;
    }
}
