package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.SelectSubjectBean;
import com.beanpodtech.allinone.widget.AutoPollRecyclerView;
import com.beanpodtech.allinone.widget.flowlayout.TagFlowLayout;

import java.util.List;

public class ClassIntroductionAdapter extends RecyclerView.Adapter {
    private List<SelectSubjectBean.ListBean> list;
    private Context mContext;
    private LayoutInflater inflate;

    public ClassIntroductionAdapter(List<SelectSubjectBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = inflate.inflate(R.layout.item_classintroduction, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        if (list.get(position).getSubjectTitle() != null && !TextUtils.isEmpty(list.get(position).getSubjectTitle())) {
            ((ViewHolder) holder).tvTitle.setVisibility(View.VISIBLE);
        } else {
            ((ViewHolder) holder).tvTitle.setVisibility(View.GONE);
        }
        ((ViewHolder) holder).tvTitle.setText(list.get(position).getSubjectTitle());
        ((ViewHolder) holder).tvDes.setText(list.get(position).getSubjectDes());
        ((ViewHolder) holder).tflSmalltype.setAdapter(new ClassIntroductionSmallTypeAdapter(list.get(position).getSubjectList(), inflate, ((ViewHolder) holder).tflSmalltype, list.size()));
        if (list.get(position).getTeacherList() != null) {
            if (list.get(position).getTeacherList().size() == 0) {
                ((ViewHolder) holder).tvTeachertitle.setVisibility(View.GONE);
            } else {
                ((ViewHolder) holder).tvTeachertitle.setVisibility(View.VISIBLE);
            }
            ((ViewHolder) holder).tvTeachertitle.setVisibility(View.VISIBLE);
            List<SelectSubjectBean.ListBean.TeacherListBean> teacherList = list.get(position).getTeacherList();
            ((ViewHolder) holder).rcvTeachers.setAdapter(new TeachersAdapter(teacherList, this.mContext, list.size()));
//            ((ViewHolder) holder).rcv_teachers.start();
        } else {
            ((ViewHolder) holder).tvTeachertitle.setVisibility(View.GONE);
        }
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    //内部类，绑定控件
    class ViewHolder extends RecyclerView.ViewHolder {
        TextView tvTitle, tvDes, tvTeachertitle;
        TagFlowLayout tflSmalltype;
        AutoPollRecyclerView rcvTeachers;

        public ViewHolder(View itemView) {
            super(itemView);
            tvTitle = itemView.findViewById(R.id.tv_title);
            tvDes = itemView.findViewById(R.id.tv_des);
            tflSmalltype = itemView.findViewById(R.id.tfl_smalltype);
            rcvTeachers = itemView.findViewById(R.id.rcv_teachers);
            rcvTeachers.setLayoutManager(new StaggeredGridLayoutManager(1,
                    StaggeredGridLayoutManager.HORIZONTAL));
            rcvTeachers.setItemAnimator(new DefaultItemAnimator());
        }
    }
}
