package com.beanpodtech.allinone.adapter;

import android.view.LayoutInflater;
import android.view.View;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.SelectSubjectBean;
import com.beanpodtech.allinone.widget.MarqueeTextView;
import com.beanpodtech.allinone.widget.flowlayout.FlowLayout;
import com.beanpodtech.allinone.widget.flowlayout.TagAdapter;
import com.beanpodtech.allinone.widget.flowlayout.TagFlowLayout;

import java.util.List;

public class ClassIntroductionSmallTypeAdapter extends TagAdapter<Object> {
    private LayoutInflater inflate;
    private TagFlowLayout tagFlowLayout;
    private int totalNum;

    public ClassIntroductionSmallTypeAdapter(List datas, LayoutInflater inflater, TagFlowLayout tagFlowLayout, int totalNum) {
        super(datas);
        this.inflate = inflater;
        this.tagFlowLayout = tagFlowLayout;
        this.totalNum = totalNum;
    }


    @Override
    public View getView(FlowLayout parent, int position, Object o) {
        MarqueeTextView tv = null;
        if (totalNum == 1) {
            tv = (MarqueeTextView) inflate.inflate(R.layout.item_classintro_tag,
                    tagFlowLayout, false);
        } else if (totalNum == 2) {
            tv = (MarqueeTextView) inflate.inflate(R.layout.item_classintro_tag_two,
                    tagFlowLayout, false);
        } else if (totalNum == 3) {
            tv = (MarqueeTextView) inflate.inflate(R.layout.item_classintro_tag_three,
                    tagFlowLayout, false);
        }

        if (o instanceof SelectSubjectBean.ListBean.SubjectListBean) {
            tv.setText("《" + ((SelectSubjectBean.ListBean.SubjectListBean) o).getSubjectName() + "》");
            tv.setRepeatCount(-1);
        }
        return tv;
    }
}
