package com.beanpodtech.allinone.adapter;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;

import com.beanpodtech.allinone.fragment.Class2Fragment;
import com.beanpodtech.allinone.fragment.ClassFragment;

public class ClassTypeAdapter extends FragmentPagerAdapter {

    private Fragment[] fragments;   //写一个fragment的数组 让数组 里元素 和title 一样多

    public ClassTypeAdapter(@NonNull FragmentManager fm) {
        super(fm);
    }

    @NonNull
    @Override
    public Fragment getItem(int position) {
        if (position == 0) {
            fragments[0] = new ClassFragment();
        } else {
            fragments[1] = new Class2Fragment();
        }
        return fragments[position];
    }

    @Override
    public int getCount() {
        return fragments.length == 0 ? 0 : fragments.length;
    }

    public void setFragments(Fragment[] fragments) {
        this.fragments = fragments;
        notifyDataSetChanged();
    }
}
