package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.beanpodtech.allinone.activity.PlayvideoActivity;
import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.AllClassdisplay;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.SpUtil;
import com.bumptech.glide.Glide;

import java.util.HashMap;
import java.util.List;

public class Classdisplay extends RecyclerView.Adapter {
    private static final String TAG = "Classdisplay";
    String userId = SpUtil.getInstace().getString(Contants.USER_ID, null);
    List<AllClassdisplay.ListBean> list;
    HashMap<String, String> map = new HashMap<>();
    Context context;
    public Classdisplay(List<AllClassdisplay.ListBean> list,Context context){
        this.list=list;
        this.context=context;
    }
    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view= LayoutInflater.from(parent.getContext()).inflate(R.layout.item_increase,parent,false);
        ViewHolder holder=new ViewHolder(view);
        return holder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
        if (context == null) {
            Log.e(TAG, "onBindViewHolder context is null");
            return;
        }

        Glide.with(context).load(list.get(position).getUrl())
                .error(R.drawable.placeholder_small)
                .into(((ViewHolder) holder).imageView);
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Bundle bundle = new Bundle();
                bundle.putCharSequence(Contants.CLASS_ID, list.get(position).getClassId());
                bundle.putCharSequence(Contants.CLASS_NAME, list.get(position).getClassName());
                PlayvideoActivity.startActivity(context, bundle);
            }});

    }

    @Override
    public int getItemCount() {
        if(list==null){ return 0;}
        return list.size();
    }
    public class ViewHolder extends RecyclerView.ViewHolder {
        ImageView imageView;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);

            imageView=itemView.findViewById(R.id.imageview);
        }
    }
}
