package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.content.res.Resources;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.res.ResourcesCompat;
import androidx.recyclerview.widget.RecyclerView;


import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.CourseArrangingInfoBean;
import com.beanpodtech.allinone.widget.LoadingView;

import java.util.List;

public class CourseArrangingAdapter extends RecyclerView.Adapter<CourseArrangingAdapter.ViewHolder> {

    private List<CourseArrangingInfoBean.ListBean> list;
    private Context mContext;

    private LayoutInflater inflate;

    private LoadingView loadingView;

    OnBtnClickListener onBtnClickListener;


    public OnBtnClickListener getOnBtnClickListener() {
        return onBtnClickListener;
    }

    public void setOnBtnClickListener(OnBtnClickListener onBtnClickListener) {
        this.onBtnClickListener = onBtnClickListener;
    }

    public CourseArrangingAdapter(List<CourseArrangingInfoBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);

        loadingView = new LoadingView(mContext, R.style.CustomDialog);
        loadingView.setTitle(R.string.pleasewait);
    }


    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = inflate.inflate(R.layout.item_course_schedule, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {

        Resources resources = mContext.getResources();

        CourseArrangingInfoBean.ListBean bean = list.get(position);

        holder.tvSubject.setText(resources.getString(R.string.schedule_subject) + bean.getSubjectName());
        holder.tvTeacher.setText(resources.getString(R.string.schedule_teacher) + bean.getTeacherName());
        holder.tvDuration.setText(resources.getString(R.string.schedule_duration) + bean.getTimeSpan() + "分钟");
        holder.tvStartEndTime.setText(resources.getString(R.string.schedule_start_end_time)
                + getTimeStr(bean.getStartTime()) + "  -  " + getTimeStr(bean.getEndTime()));


        long startTime = (bean.getStartTime() * 1000) - (10 * 60 * 1000);
        long endTime = bean.getEndTime() * 1000;

        if (endTime < System.currentTimeMillis()) { // 过期
            holder.btnBegin.setBackground(ResourcesCompat.getDrawable(resources, R.drawable.bg_btn_schedule_gray, null));

        } else if (startTime < System.currentTimeMillis() && System.currentTimeMillis() < endTime) { // 当前时间在 开始时间前10分钟 - 结束时间之间
            holder.btnBegin.setBackground(ResourcesCompat.getDrawable(resources, R.drawable.bg_btn_schedule, null));

        } else {  //    当前时间 小于开始时间前 10分钟
            holder.btnBegin.setBackground(ResourcesCompat.getDrawable(resources, R.drawable.bg_btn_schedule_red, null));
        }

        holder.btnBegin.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (onBtnClickListener != null) onBtnClickListener.onBtnClick(position);
            }
        });

    }

    //  改变按钮言颜色
    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position, @NonNull List<Object> payloads) {

        if (payloads.isEmpty()) {
            onBindViewHolder(holder, position);
        } else {
            Resources resources = mContext.getResources();
            CourseArrangingInfoBean.ListBean bean = list.get(position);
            long startTime = (bean.getStartTime() * 1000) - (10 * 60 * 1000);
            long endTime = bean.getEndTime() * 1000;

            if (endTime < System.currentTimeMillis()) { // 过期
                holder.btnBegin.setBackground(ResourcesCompat.getDrawable(resources, R.drawable.bg_btn_schedule_gray, null));

            } else if (startTime < System.currentTimeMillis() && System.currentTimeMillis() < endTime) { // 当前时间在 开始时间前10分钟 - 结束时间之间
                holder.btnBegin.setBackground(ResourcesCompat.getDrawable(resources, R.drawable.bg_btn_schedule, null));

            } else {  //    当前时间 小于开始时间前 10分钟
                holder.btnBegin.setBackground(ResourcesCompat.getDrawable(resources, R.drawable.bg_btn_schedule_red, null));
            }
        }
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {

        TextView tvSubject, tvTeacher, tvDuration, tvStartEndTime;
        Button btnBegin;

        public ViewHolder(View itemView) {
            super(itemView);
            tvSubject = itemView.findViewById(R.id.tv_subject);
            tvTeacher = itemView.findViewById(R.id.tv_teacher);
            tvDuration = itemView.findViewById(R.id.tv_duration);
            tvStartEndTime = itemView.findViewById(R.id.tv_start_end_time);
            btnBegin = itemView.findViewById(R.id.btn_begin);
        }
    }


    private String getTimeStr(long seconds) {

        return DateFormat.format("yyyy-MM-dd HH:mm", seconds * 1000).toString();

    }

    public interface OnBtnClickListener {

        void onBtnClick(int pos);


    }


}
