package com.beanpodtech.allinone.adapter;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.FilterBean;
import com.beanpodtech.allinone.widget.flowlayout.FlowLayout;
import com.beanpodtech.allinone.widget.flowlayout.TagAdapter;
import com.beanpodtech.allinone.widget.flowlayout.TagFlowLayout;


import java.util.List;

public class FilterAdapter extends TagAdapter<Object> {
    private LayoutInflater inflate;
    private TagFlowLayout tagFlowLayout;

    public FilterAdapter(List datas, LayoutInflater inflater, TagFlowLayout tagFlowLayout) {
        super(datas);
        this.inflate = inflater;
        this.tagFlowLayout = tagFlowLayout;
    }


    @Override
    public View getView(FlowLayout parent, int position, Object object) {
        RelativeLayout rl_root = (RelativeLayout) inflate.inflate(R.layout.item_filter,
                tagFlowLayout, false);
        if (object instanceof FilterBean.SubjectsBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FilterBean.SubjectsBean) object).getFilterSubjectName());
        } else if (object instanceof FilterBean.SubjectsBean.SortsBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FilterBean.SubjectsBean.SortsBean) object).getFilterTypeName());
        } else if (object instanceof FilterBean.SubjectsBean.SortsBean.TeachersBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FilterBean.SubjectsBean.SortsBean.TeachersBean) object).getFilterTeacherName());
        } else if (object instanceof FilterBean.SubjectsBean.SortsBean.TeachersBean.OutlinesBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FilterBean.SubjectsBean.SortsBean.TeachersBean.OutlinesBean) object).getFilterOutlineName());
        } else if (object instanceof FilterBean.SubjectsBean.SortsBean.TeachersBean.OutlinesBean.OutlineClassificationBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FilterBean.SubjectsBean.SortsBean.TeachersBean.OutlinesBean.OutlineClassificationBean) object).getFilterOutlineClassificationName());
        }/* else if (object instanceof SubjectFilterBean.SubjectListBean) {
            tv.setText(((SubjectFilterBean.SubjectListBean) object).getSubjectName());
        }*/ /*else if (object instanceof SelectSubjectBean.ListBean.SubjectListBean) {
            tv.setText(((SelectSubjectBean.ListBean.SubjectListBean) object).getSubjectName());
        }*/

        return rl_root;
    }

    @Override
    public void onSelected(int position, View view) {
        ((RelativeLayout) view).findViewById(R.id.tv_filter).setBackgroundResource(R.drawable.bg_subjectfilter_check);
        ((TextView) ((RelativeLayout) view).findViewById(R.id.tv_filter)).setTextColor(Color.parseColor("#ffffff"));
        super.onSelected(position, view);
    }

    @Override
    public void unSelected(int position, View view) {
        ((RelativeLayout) view).findViewById(R.id.tv_filter).setBackgroundResource(R.drawable.bg_subjectfilter_uncheck);
        ((TextView) ((RelativeLayout) view).findViewById(R.id.tv_filter)).setTextColor(Color.parseColor("#99ffffff"));
        super.unSelected(position, view);
    }

    class ViewHolder {
        TextView tv_filter;
    }
}
