package com.beanpodtech.allinone.adapter;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.SubjectFilterBean;
import com.beanpodtech.allinone.widget.flowlayout.FlowLayout;
import com.beanpodtech.allinone.widget.flowlayout.TagAdapter;
import com.beanpodtech.allinone.widget.flowlayout.TagFlowLayout;

import java.util.List;

public class FilterClassAdapter extends TagAdapter<SubjectFilterBean.SubjectListBean> {
    private LayoutInflater inflate;
    private TagFlowLayout tagFlowLayout;

    public FilterClassAdapter(List datas, LayoutInflater inflater, TagFlowLayout tagFlowLayout) {
        super(datas);
        this.inflate = inflater;
        this.tagFlowLayout = tagFlowLayout;
    }


    @Override
    public View getView(FlowLayout parent, int position, SubjectFilterBean.SubjectListBean object) {
        RelativeLayout rl_root = (RelativeLayout) inflate.inflate(R.layout.item_filter,
                tagFlowLayout, false);
        ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(object.getSubjectName());


        return rl_root;
    }

    @Override
    public void onSelected(int position, View view) {
        ((RelativeLayout) view).findViewById(R.id.tv_filter).setBackgroundResource(R.drawable.bg_subjectfilter_check);
        ((TextView) ((RelativeLayout) view).findViewById(R.id.tv_filter)).setTextColor(Color.parseColor("#ffffff"));
        super.onSelected(position, view);
    }

    @Override
    public void unSelected(int position, View view) {
        ((RelativeLayout) view).findViewById(R.id.tv_filter).setBackgroundResource(R.drawable.bg_subjectfilter_uncheck);
        ((TextView) ((RelativeLayout) view).findViewById(R.id.tv_filter)).setTextColor(Color.parseColor("#99ffffff"));
        super.unSelected(position, view);
    }

    class ViewHolder {
        TextView tv_filter;
    }
}
