package com.beanpodtech.allinone.adapter;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.FreeFilterBean2;
import com.beanpodtech.allinone.widget.flowlayout.FlowLayout;
import com.beanpodtech.allinone.widget.flowlayout.TagAdapter;
import com.beanpodtech.allinone.widget.flowlayout.TagFlowLayout;

import java.util.List;

public class FreeFilterAdapter extends TagAdapter<Object> {
    private LayoutInflater inflate;
    private TagFlowLayout tagFlowLayout;

    public FreeFilterAdapter(List datas, LayoutInflater inflater, TagFlowLayout tagFlowLayout) {
        super(datas);
        this.inflate = inflater;
        this.tagFlowLayout = tagFlowLayout;
    }


    @Override
    public View getView(FlowLayout parent, int position, Object object) {
        RelativeLayout rl_root = (RelativeLayout) inflate.inflate(R.layout.item_filter,
                tagFlowLayout, false);
        if (object instanceof FreeFilterBean2.LevelBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FreeFilterBean2.LevelBean) object).getFilterLevelName());
        } else if (object instanceof FreeFilterBean2.LevelBean.SubjectsBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FreeFilterBean2.LevelBean.SubjectsBean) object).getFilterSubjectName());
        } else if (object instanceof FreeFilterBean2.LevelBean.SubjectsBean.TypesBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FreeFilterBean2.LevelBean.SubjectsBean.TypesBean) object).getFilterTypeName());
        } else if (object instanceof FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean) object).getFilterOutlineName());
        } else if (object instanceof FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean.TeachersBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean.TeachersBean) object).getFilterTeacherName());
//        } else if (object instanceof FreeFilterBean2.LevelBean.SubjectsBean.OutLinesBean.TeachersBean.OutLinesBean.OutLineclassificationsBean) {
//            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((FreeFilterBean2.LevelBean.SubjectsBean.OutLinesBean.TeachersBean.OutLinesBean.OutLineclassificationsBean) object).getFilterOutLineclassificationName());
        }

        return rl_root;
    }

    @Override
    public void onSelected(int position, View view) {
        view.findViewById(R.id.tv_filter).setBackgroundResource(R.drawable.shape_selected);
        ((TextView) view.findViewById(R.id.tv_filter)).setTextColor(Color.parseColor("#ffffff"));
        super.onSelected(position, view);
    }

    @Override
    public void unSelected(int position, View view) {
        view.findViewById(R.id.tv_filter).setBackgroundResource(R.drawable.bg_subjectfilter_uncheck);
        ((TextView) view.findViewById(R.id.tv_filter)).setTextColor(Color.parseColor("#99ffffff"));
        super.unSelected(position, view);
    }

    class ViewHolder {
        TextView tv_filter;
    }
}
