package com.beanpodtech.allinone.adapter;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.RecordVideoBean;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class HomeRecordAdapter  extends BaseQuickAdapter<RecordVideoBean.ListBean, BaseViewHolder> {

    private static final String TAG = "HomeRecordAdapter";

    public HomeRecordAdapter(int layoutResId, @Nullable List<RecordVideoBean.ListBean> data) {
        super(layoutResId, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder helper, RecordVideoBean.ListBean bean) {

        helper.setText(R.id.tv_class, bean.getCoursesName());
        helper.setText(R.id.tv_type, bean.getSubjectName());
        helper.setText(R.id.tv_teacher, "教师" + helper.getAdapterPosition());
//        helper.setText(R.id.tv_progress,  bean.getStudyTime());
        helper.setText(R.id.tv_time,  bean.getVideoDuration());

    }
}
