package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.MyAccountBean;
import com.beanpodtech.allinone.utils.MathUtils;

import java.util.List;

public class MyAccountAdapter extends RecyclerView.Adapter {
    private List<MyAccountBean.ListBean> list;
    private Context mContext;
    private LayoutInflater inflate;

    public MyAccountAdapter(List<MyAccountBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = inflate.inflate(R.layout.item_myaccount, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        ((ViewHolder) holder).tvTitle.setText(list.get(position).getClassName());
        double usedTime = list.get(position).getUsedTime();
        double leftTime = list.get(position).getLeftTime();
        ((ViewHolder) holder).tvRemaining.setText("剩余" + MathUtils.txfloat(leftTime, 60) + "分钟");
        ((ViewHolder) holder).tvAlready.setText("已学习" + MathUtils.txfloat(usedTime, 60) + "分钟");
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    //内部类，绑定控件
    class ViewHolder extends RecyclerView.ViewHolder {
        TextView tvTitle, tvRemaining, tvAlready;

        public ViewHolder(View itemView) {
            super(itemView);
            tvTitle = (TextView) itemView.findViewById(R.id.tv_title);
            tvRemaining = (TextView) itemView.findViewById(R.id.tv_remaining);
            tvAlready = (TextView) itemView.findViewById(R.id.tv_already);
        }
    }

}
