package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.QuestionBean;

import java.util.List;

public class QuestionAdapter extends BaseAdapter {
    private List<QuestionBean.ListBean> list;
    private Context mContext;
    private LayoutInflater inflate;

    public QuestionAdapter(List<QuestionBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
    }


    @Override
    public int getCount() {
        return list.size();
    }

    @Override
    public Object getItem(int position) {
        return list.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            convertView = inflate.inflate(R.layout.item_questions, null);
            viewHolder.tvQuestionName = convertView.findViewById(R.id.tv_question_name);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }
        viewHolder.tvQuestionName.setText(list.get(position).getQuestionName());
        if (list.get(position).isQuestionStatus()) {
            viewHolder.tvQuestionName.setTextColor(Color.parseColor("#ee1313"));
        } else {
            viewHolder.tvQuestionName.setTextColor(Color.parseColor("#767676"));
        }
        return convertView;
    }

    //内部类，绑定控件
    class ViewHolder {
        private TextView tvQuestionName/*, tvAnswerTitle, tvAnswerContent*/;
//        private LinearLayout llAnswer;
    }

}
