package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.AnswerBean;
import com.beanpodtech.allinone.bean.QuestionBean;
import com.bumptech.glide.Glide;

import java.util.List;

public class QuestionPopupAdapter extends BaseAdapter {
    private List<QuestionBean.ListBean> list;
    private Context mContext;
    private LayoutInflater inflate;

    public QuestionPopupAdapter(List<QuestionBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
    }

    OnPicClickListener onPicClickListener;

    public OnPicClickListener getOnPicClickListener() {
        return onPicClickListener;
    }

    public void setOnPicClickListener(OnPicClickListener onPicClickListener) {
        this.onPicClickListener = onPicClickListener;
    }

    @Override
    public int getCount() {
        return list.size();
    }

    @Override
    public Object getItem(int position) {
        return list.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            viewHolder = new ViewHolder();
            convertView = inflate.inflate(R.layout.item_questions_popup, null);
            viewHolder.tvQuestionName = convertView.findViewById(R.id.tv_question_name);
            viewHolder.tvAnswer = convertView.findViewById(R.id.tv_answer);
            viewHolder.ivAnswer = convertView.findViewById(R.id.iv_answer);

            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }
        viewHolder.tvQuestionName.setText(list.get(position).getQuestionName());
        if (list.get(position).isQuestionStatus()) {
            viewHolder.tvQuestionName.setTextColor(Color.parseColor("#ee1313"));
        } else {
            viewHolder.tvQuestionName.setTextColor(Color.parseColor("#767676"));
        }

        if (list.get(position).getAnswerBean() == null) {
            viewHolder.tvAnswer.setVisibility(View.GONE);
            viewHolder.ivAnswer.setVisibility(View.GONE);
        } else {
            AnswerBean answerBean = list.get(position).getAnswerBean();
            if (answerBean.getAnswerType() == 1) { // 图片
                viewHolder.tvAnswer.setVisibility(View.GONE);
                viewHolder.ivAnswer.setVisibility(View.VISIBLE);
                Glide.with(mContext).load(answerBean.getAnswerContent()).into(viewHolder.ivAnswer);
            } else { // 2 文字
                viewHolder.tvAnswer.setVisibility(View.VISIBLE);
                viewHolder.ivAnswer.setVisibility(View.GONE);
                viewHolder.tvAnswer.setText(answerBean.getAnswerContent() + "");
            }
        }

        viewHolder.ivAnswer.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (onPicClickListener != null) {
                    onPicClickListener.onPicAnswerClicked(position);
                }
            }
        });

        return convertView;
    }

    //内部类，绑定控件
    class ViewHolder {
        private TextView tvQuestionName/*, tvAnswerTitle, tvAnswerContent*/;
//        private LinearLayout llAnswer;

        private TextView tvAnswer;
        private ImageView ivAnswer;
    }

    public interface OnPicClickListener {

        void onPicAnswerClicked(int pos);
    }

}
