package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.beanpodtech.allinone.R;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;

import java.util.List;

public class RTCQuequeAdapter extends RecyclerView.Adapter {
    private List<String> list;
    private Context mContext;
    private LayoutInflater inflate;
    private RequestOptions requestOptions;

    public RTCQuequeAdapter(List<String> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
        requestOptions = new RequestOptions()
                .error(R.drawable.temp_video_bg)
                .circleCrop()
                .diskCacheStrategy(DiskCacheStrategy.ALL);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = inflate.inflate(R.layout.item_rtc_queue, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
        Glide.with(this.mContext)
                .load("https://ss2.bdstatic.com/70cFvnSh_Q1YnxGkpoWK1HF6hhy/it/u=1048926945,1586672807&fm=26&gp=0.jpg")
                .apply(requestOptions)
                .into(((ViewHolder) holder).civHead);
//        ((ViewHolder) holder).class_name.setText(list.get(position).getSubjectName());
//        if (list.get(position).getSubjectTitle() != null && !TextUtils.isEmpty(list.get(position).getSubjectTitle())) {
//            ((ViewHolder) holder).tv_title.setVisibility(View.GONE);
//            ((ViewHolder) holder).tv_title.setText(list.get(position).getSubjectTitle());
//        } else {
//            ((ViewHolder) holder).tv_title.setVisibility(View.GONE);
//        }
//        ((ViewHolder) holder).id_num.setText("语文");
//        holder.itemView.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                Intent intent = new Intent(v.getContext(), PlayvideoActivity.class);
//                Bundle bundle = new Bundle();
//                bundle.putCharSequence("name", list.get(position).getSubjectName());
//                intent.putExtras(bundle);
//                v.getContext().startActivity(intent);
//
//            }
//        });
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    //内部类，绑定控件
    class ViewHolder extends RecyclerView.ViewHolder {
        TextView tvName;
        ImageView civHead;

        public ViewHolder(View itemView) {
            super(itemView);
            tvName = (TextView) itemView.findViewById(R.id.tv_name);
            civHead = itemView.findViewById(R.id.civ_head);
        }
    }
}
