package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.RecordVideoBean;
import com.beanpodtech.allinone.utils.DateUtils;
import com.beanpodtech.allinone.utils.PlayVideoUtils;
import com.beanpodtech.allinone.widget.LoadingView;
import com.beanpodtech.allinone.widget.RoundImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;

import java.util.List;

//import com.aliyun.solution.longvideo.activity.AlivcPlayerActivity;

public class RecordVideoAdapter extends RecyclerView.Adapter {
    private static final String TAG = "VideoAdapter";
    private List<RecordVideoBean.ListBean> list;
    private Context mContext;
    private LayoutInflater inflate;
    private LoadingView loadingView;
    private RequestOptions requestOptions;
    private boolean isDelete = false;

    public RecordVideoAdapter(List<RecordVideoBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
        loadingView = new LoadingView(mContext, R.style.CustomDialog);
        loadingView.setTitle(R.string.pleasewait);
        requestOptions = new RequestOptions()
                .error(R.drawable.temp_video_bg)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = inflate.inflate(R.layout.course_record, viewGroup, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    public void setIsDelete(boolean isDelete) {
        this.isDelete = isDelete;
        notifyDataSetChanged();
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
        if (isDelete) {
            ((ViewHolder) holder).ivSelect.setVisibility(View.VISIBLE);
        } else {
            ((ViewHolder) holder).ivSelect.setVisibility(View.GONE);
        }
        if (list.get(position).getStudyTime() != null && !TextUtils.isEmpty(list.get(position).getStudyTime())) {
            long time = Long.parseLong(list.get(position).getStudyTime());
            ((ViewHolder) holder).tvTime.setText("日期:" + DateUtils.format(time * 1000, DateUtils.DEFAULT_FORMATS));
        }
        ((ViewHolder) holder).ivSelect.setBackgroundDrawable(list.get(position).isCheck() ? mContext.getResources().getDrawable(R.drawable.record_check) : mContext.getResources().getDrawable(R.drawable.record_uncheck));
        ((ViewHolder) holder).className.setText(list.get(position).getSubjectName());
        ((ViewHolder) holder).tvTitle.setText(list.get(position).getCoursesName());
        ((ViewHolder) holder).tvTotaltime.setText(list.get(position).getVideoDuration());
        ((ViewHolder) holder).ivSelect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                list.get(position).setCheck(!list.get(position).isCheck());
                notifyDataSetChanged();
            }
        });
        Glide.with(this.mContext)
                .load(list.get(position).getCoverUrl())
                .apply(requestOptions)
                .into(((ViewHolder) holder).rivBg);
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loadingView.show();
                PlayVideoUtils.getInstance().setVideoId(list.get(position).getVideoId()).setContext(mContext).setCourseId(list.get(position).getCourseId()).setType(PlayVideoUtils.NORMAL_VIDEO).setIsNeedRecord(true).build();

//                getPlayAuth(list.get(position));
            }
        });
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    //内部类，绑定控件
    class ViewHolder extends RecyclerView.ViewHolder {
        TextView className;
        TextView tvTotaltime, tvTitle, tvTime;
        RoundImageView rivBg;
        ImageView ivSelect;

        public ViewHolder(View itemView) {
            super(itemView);
            className = (TextView) itemView.findViewById(R.id.class_name);
            tvTotaltime = (TextView) itemView.findViewById(R.id.tv_totaltime);
            tvTitle = (TextView) itemView.findViewById(R.id.tv_title);
            tvTime = itemView.findViewById(R.id.tv_time);
            rivBg = (RoundImageView) itemView.findViewById(R.id.riv_bg);
            ivSelect = (ImageView) itemView.findViewById(R.id.iv_select);
        }
    }

//    private void getPlayAuth(final RecordVideoBean.ListBean bean) {
//        OkGoBuilder.getInstance().url(UrlConfig.GET_PLAYAUTH).Builder((Activity) mContext).method(OkGoBuilder.PSOT).cls(AliVideoBean.class).requestBody(HttpUtils.getRequestJson(getRequestBody(bean))).callback(new OkGoUtil<AliVideoBean>(AliVideoBean.class) {
//            @Override
//            public void onSuccess(Response<AliVideoBean> response) {
//                loadingView.dismiss();
//                AliVideoBean body = response.body();
//                if (body != null) {
//                    if (body.isAllowPlay()) {
//                        AlivcPlayerActivity.startAlivcPlayerActivity(mContext, body, bean.getCourseId(), bean.getVideoId());
//                    } else {
//                        ToastUtils.show(mContext, R.string.not_have_role_watch);
//                    }
//                } else {
//                    ToastUtils.show(mContext, R.string.neterror);
//                }
////                TimeCounter timeCounter = TimeCounter.getInstance(mContext);
////                FileUtil fileUtil = new FileUtil();
////                byte[] nativeBitmap;
////                byte[] remoteBitmap;
////                final BuyVideoIdBean[] data = new BuyVideoIdBean[1];
////                timeCounter.setBitmapExsitFlag(false);
////                String fileName = timeCounter.genFileName(SpUtil.getInstace().getString(Contants.USER_NAME, "unknown"),
////                        bean.getVideoId(), System.currentTimeMillis());
////                //get natvie bitmap
////                if (timeCounter.isBitMapFileExist(fileName)) {
////                    nativeBitmap = fileUtil.readFile(fileName);
////
////                    timeCounter.setBitmapExsitFlag(true);
////                    //get counter
////                    SpUtil.getInstace().getInt(fileName, 0);
////                }
////                //get remote bitmap
////                HttpParams params = new HttpParams();
////                params.put("userMobileNumber", "13555770239");
////                params.put("videoId", "1233333");
////                SyncUtils.getInstance().params(params).callback(new OnSyncServerCallBack() {
////                    @Override
////                    public void onSyncServer(Object object) {
////
////                        data[0] = (BuyVideoIdBean) object;
////                        data[0].getData().getCounter();
////                        data[0].getData().getReverseData();
////
////                    }
////
//////                    @Override
//////                    public void onSyncServer(Response response) {
//////                        Log.d(TAG, "body"+response.body());
//////                    }
////
////                    /*String str1 = "abcd";
////                    byte[] bs1 = str1.getBytes();
////                    byte[] bs1 = {97,98,100};
////                    String s = new String(bs1);*/
////                }).build(SyncUtils.BUYVIDEOID);
//            }
//
//            @Override
//            public void onError(Response<AliVideoBean> response) {
//                loadingView.dismiss();
//                super.onError(response);
//            }
//        }).build();
//    }
//
//    private HashMap<String, String> getRequestBody(RecordVideoBean.ListBean bean) {
//        HashMap<String, String> map = new HashMap<>();
//        map.put("userId", SpUtil.getInstace().getString(Contants.USER_ID, null));
//        map.put("videoId", bean.getVideoId());
//        map.put("type", "1");
//        return map;
//    }
}