package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beanpodtech.allinone.activity.SearchResultActivity;
import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.widget.flowlayout.FlowLayout;
import com.beanpodtech.allinone.widget.flowlayout.TagAdapter;
import com.beanpodtech.allinone.widget.flowlayout.TagFlowLayout;

import java.util.List;

public class SearchHistoryAdapter extends TagAdapter<String> {
    private LayoutInflater inflate;
    private TagFlowLayout tagFlowLayout;
    private Context context;
    private List<String> list;

    public SearchHistoryAdapter(Context context, List<String> datas, LayoutInflater inflater, TagFlowLayout tagFlowLayout) {
        super(datas);
        this.inflate = inflater;
        this.tagFlowLayout = tagFlowLayout;
        this.context = context;
        this.list = datas;
    }


    @Override
    public View getView(FlowLayout parent, int position, final String s) {
        RelativeLayout rl_root = (RelativeLayout) inflate.inflate(R.layout.item_searchhistory,
                tagFlowLayout, false);
        ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(s);

        return rl_root;
    }

    @Override
    public void onSelected(int position, View view) {
        super.onSelected(position, view);
        SearchResultActivity.startActivity(context, list.get(position));
//        unSelected(position, view);
    }
}
