package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.SmartQABean;
import com.bumptech.glide.request.RequestOptions;

import java.util.List;

//import com.aliyun.solution.longvideo.activity.AlivcPlayerActivity;

public class SmartQAAdapter extends RecyclerView.Adapter {
    private static final String TAG = "SmartQAAdapter";
    private static final int TYPE_SEND_TEXT = 1;
    private static final int TYPE_RECEIVE_TEXT = 2;
    private static final int SEND_TEXT = R.layout.item_text_send;
    private static final int RECEIVE_TEXT = R.layout.item_text_receive;
    private Context mContext;
    private List<SmartQABean.ListBean> list;
    private LayoutInflater inflater;
    private RequestOptions requestOptions;

    public SmartQAAdapter(Context mContext, List<SmartQABean.ListBean> list) {
        this.mContext = mContext;
        this.list = list;
        inflater = LayoutInflater.from(mContext);
        requestOptions = new RequestOptions()
                .error(R.drawable.ic_head_default_left);

    }

    @Override
    public int getItemViewType(int position) {
        if (list.get(position).getSendType() == 1) {
            return TYPE_SEND_TEXT;
        } else if (list.get(position).getSendType() == 2) {
            return TYPE_RECEIVE_TEXT;
        }
        return 0;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        if (viewType == TYPE_SEND_TEXT) {
            View inflateSend = LayoutInflater.from(mContext).inflate(SEND_TEXT, viewGroup, false);
            return new ViewHolderSend(inflateSend);
        }
        if (viewType == TYPE_RECEIVE_TEXT) {
            View inflateReceive = LayoutInflater.from(mContext).inflate(RECEIVE_TEXT, viewGroup, false);
            return new ViewHolderReceiver(inflateReceive);
        }
        return null;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof ViewHolderSend) {
            ((ViewHolderSend) holder).chatItemContentText.setText(list.get(position).getContent());
            ((ViewHolderSend) holder).itemTvTime.setText((list.get(position).getSendTime() != null && !TextUtils.isEmpty(list.get(position).getSendTime())) ? list.get(position).getSendTime() : "");
        } else if (holder instanceof ViewHolderReceiver) {
            ((ViewHolderReceiver) holder).chatItemContentText.setText(list.get(position).getContent());
            ((ViewHolderReceiver) holder).itemTvTime.setText((list.get(position).getSendTime() != null && !TextUtils.isEmpty(list.get(position).getSendTime())) ? list.get(position).getSendTime() : "");
//            Glide.with(this.mContext)
//                    .load(list.get(position).getAvaterUrl())
//                    .apply(requestOptions)
//                    .into(((ViewHolderReceiver) holder).chatItemHeader);
        }
    }

    @Override
    public int getItemCount() {
        return list != null ? list.size() : 0;
    }

    //内部类，绑定控件
    class ViewHolderSend extends RecyclerView.ViewHolder {
        //        CircleImageView chatItemHeader;
        TextView chatItemContentText, itemTvTime;

        public ViewHolderSend(View itemView) {
            super(itemView);
//            chatItemHeader = itemView.findViewById(R.id.chat_item_header);
            chatItemContentText = itemView.findViewById(R.id.chat_item_content_text);
            itemTvTime = itemView.findViewById(R.id.item_tv_time);
        }
    }

    //内部类，绑定控件
    class ViewHolderReceiver extends RecyclerView.ViewHolder {
        //        CircleImageView chatItemHeader;
        TextView chatItemContentText, itemTvTime;

        public ViewHolderReceiver(View itemView) {
            super(itemView);
//            chatItemHeader = itemView.findViewById(R.id.chat_item_header);
            chatItemContentText = itemView.findViewById(R.id.chat_item_content_text);
            itemTvTime = itemView.findViewById(R.id.item_tv_time);
        }
    }
}