package com.beanpodtech.allinone.adapter;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.Getstudyplan;
import com.beanpodtech.allinone.widget.flowlayout.FlowLayout;
import com.beanpodtech.allinone.widget.flowlayout.TagAdapter;
import com.beanpodtech.allinone.widget.flowlayout.TagFlowLayout;

import java.util.List;

public class StudyPlanAdapter extends TagAdapter<Object> {
    private LayoutInflater inflate;
    private TagFlowLayout tagFlowLayout;

    public StudyPlanAdapter(List datas,LayoutInflater inflater, TagFlowLayout tagFlowLayout) {
        super(datas);
        this.inflate = inflater;
        this.tagFlowLayout = tagFlowLayout;
    }

    @Override
    public View getView(FlowLayout parent, int position, Object object) {
        RelativeLayout rl_root = (RelativeLayout) inflate.inflate(R.layout.item_plan_study, tagFlowLayout, false);
        if (object instanceof Getstudyplan.ClassesBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((Getstudyplan.ClassesBean) object).getFilterClassName());
        } else if(object instanceof Getstudyplan.ClassesBean.CourseBean){
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((Getstudyplan.ClassesBean.CourseBean) object).getFilterCourseName());
        } else if (object instanceof Getstudyplan.ClassesBean.CourseBean.SubjectsBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((Getstudyplan.ClassesBean.CourseBean.SubjectsBean) object).getFilterSubjectName());
        } else if (object instanceof Getstudyplan.ClassesBean.CourseBean.SubjectsBean.TypesBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((Getstudyplan.ClassesBean.CourseBean.SubjectsBean.TypesBean) object).getFilterTypeName());
        } else if (object instanceof Getstudyplan.ClassesBean.CourseBean.SubjectsBean.TypesBean.TeachersBean) {
            ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(((Getstudyplan.ClassesBean.CourseBean.SubjectsBean.TypesBean.TeachersBean) object).getFilterTeacherName());
        }
//        ((TextView) rl_root.findViewById(R.id.tv_filter)).setText(testClass.getAa());
        return rl_root;
    }



    @Override
    public void onSelected(int position, View view) {
        ((RelativeLayout) view).findViewById(R.id.tv_filter).setBackgroundResource(R.drawable.bg_studyplan_check);
        ((TextView) ((RelativeLayout) view).findViewById(R.id.tv_filter)).setTextColor(Color.parseColor("#ffffff"));
        super.onSelected(position, view);
    }

    @Override
    public void unSelected(int position, View view) {
        ((RelativeLayout) view).findViewById(R.id.tv_filter).setBackgroundResource(R.drawable.bg_studyplan_uncheck);
        ((TextView) ((RelativeLayout) view).findViewById(R.id.tv_filter)).setTextColor(Color.parseColor("#000000"));
        super.unSelected(position, view);
    }

    class ViewHolder {
        TextView tv_filter;
    }
}
