package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.GetPlanBean;
import com.beanpodtech.allinone.utils.PlayVideoUtils;
import com.beanpodtech.allinone.widget.LoadingView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;

import java.util.List;

public class StudyPlanListAdapter extends RecyclerView.Adapter {
    public static final boolean ISDELETE = true;
    public static final boolean ISNOTDELETE = false;
    private static final String TAG = "StudyPlanListAdapter";
    private List<GetPlanBean.ListBean> list;
    private Context mContext;
    private LayoutInflater inflate;
    private LoadingView loadingView;
    private RequestOptions requestOptions;
    private boolean isDelete = false;

    public StudyPlanListAdapter(List<GetPlanBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
        loadingView = new LoadingView(mContext, R.style.CustomDialog);
        loadingView.setTitle(R.string.pleasewait);
        requestOptions = new RequestOptions()
                .error(R.drawable.temp_video_bg)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = inflate.inflate(R.layout.item_studyplan_recycleciew, viewGroup, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    public void setIsDelete(boolean isDelete) {
        this.isDelete = isDelete;
        notifyDataSetChanged();
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
        if (isDelete) {
            ((ViewHolder) holder).planDelete.setVisibility(View.VISIBLE);
        } else {
            ((ViewHolder) holder).planDelete.setVisibility(View.GONE);
        }
        Glide.with(this.mContext)
                .load(list.get(position).getPicturePath())
                .apply(requestOptions)
                .into(((ViewHolder) holder).picture);
        ((ViewHolder) holder).videoName.setText(list.get(position).getVideoName());
        ((ViewHolder) holder).title.setText(list.get(position).getVideoName());
        ((ViewHolder) holder).Course.setText(list.get(position).getClassName() + "   " + list.get(position).getTeacherName());
        ((ViewHolder) holder).Time.setText("总时长:" + list.get(position).getVideoDuration());
        ((ViewHolder) holder).planDelete.setBackgroundDrawable(list.get(position).isSelect() ? mContext.getResources().getDrawable(R.drawable.record_check) : mContext.getResources().getDrawable(R.drawable.record_uncheck));
        ((ViewHolder) holder).planDelete.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                list.get(position).setSelect(!list.get(position).isSelect());
                notifyDataSetChanged();
            }
        });
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                PlayVideoUtils.getInstance().setVideoId(list.get(position).getVideoId()).setContext(mContext).setCourseId(list.get(position).getCourseId()).setType(PlayVideoUtils.NORMAL_VIDEO).setIsNeedRecord(true).build();
//                PlayVideoUtils utils = new PlayVideoUtils(mContext, list.get(position).getVideoId(), list.get(position).getCourseId(), PlayVideoUtils.NORMAL_VIDEO);
//                utils.getPlayAuthToPlay();
//                loadingView.show();
//                getPlayAuth(list.get(position));
            }
        });
//        if (list.get(position).getStudyTime() != null && !TextUtils.isEmpty(list.get(position).getStudyTime())) {
//            long time = Long.parseLong(list.get(position).getStudyTime());
//            ((ViewHolder) holder).tv_time.setText("日期:" + DateUtils.format(time * 1000, DateUtils.DEFAULT_FORMATS));
//        }
//        ((ViewHolder) holder).iv_select.setBackgroundDrawable(list.get(position).isCheck() ? mContext.getResources().getDrawable(R.drawable.record_check) : mContext.getResources().getDrawable(R.drawable.record_uncheck));
//        ((ViewHolder) holder).class_name.setText(list.get(position).getSubjectName());
//        ((ViewHolder) holder).tv_title.setText(list.get(position).getCoursesName());
//        ((ViewHolder) holder).tv_totaltime.setText(list.get(position).getVideoDuration());
//        ((ViewHolder) holder).iv_select.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                list.get(position).setCheck(!list.get(position).isCheck());
//                notifyDataSetChanged();
//            }
//        });
//        Glide.with(this.mContext)
//                .load(list.get(position).getCoverUrl())
//                .apply(requestOptions)
//                .into(((ViewHolder) holder).riv_bg);
//        holder.itemView.setOnClickListener(new View.OnClickListener() {
//            @Override
//            public void onClick(View v) {
//                loadingView.show();
//                getPlayAuth(list.get(position));
//            }
//        });
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    //内部类，绑定控件
    class ViewHolder extends RecyclerView.ViewHolder {
        ImageView picture, planDelete;
        TextView videoName, title, Course, Time;

        public ViewHolder(View itemView) {
            super(itemView);
            picture = itemView.findViewById(R.id.picture);
            planDelete = itemView.findViewById(R.id.plan_delete);
            videoName = itemView.findViewById(R.id.videoName);
            title = itemView.findViewById(R.id.title);
            Course = itemView.findViewById(R.id.Course);
            Time = itemView.findViewById(R.id.Time);
        }
    }

//    private void getPlayAuth(final RecordVideoBean.ListBean bean) {
//        OkGoBuilder.getInstance().url(UrlConfig.GET_PLAYAUTH).Builder((Activity) mContext).method(OkGoBuilder.PSOT).cls(AliVideoBean.class).requestBody(HttpUtils.getRequestJson(getRequestBody(bean))).callback(new OkGoUtil<AliVideoBean>(AliVideoBean.class) {
//            @Override
//            public void onSuccess(Response<AliVideoBean> response) {
//                loadingView.dismiss();
//                AliVideoBean body = response.body();
//                if (body != null) {
//                    if (body.isAllowPlay()) {
//                        AlivcPlayerActivity.startAlivcPlayerActivity(mContext, body, bean.getCourseId(), bean.getVideoId());
//                    } else {
//                        ToastUtils.show(mContext, "该视频您无权限观看");
//                    }
//                } else {
//                    ToastUtils.show(mContext, "网络异常");
//                }
////                TimeCounter timeCounter = TimeCounter.getInstance(mContext);
////                FileUtil fileUtil = new FileUtil();
////                byte[] nativeBitmap;
////                byte[] remoteBitmap;
////                final BuyVideoIdBean[] data = new BuyVideoIdBean[1];
////                timeCounter.setBitmapExsitFlag(false);
////                String fileName = timeCounter.genFileName(SpUtil.getInstace().getString(Contants.USER_NAME, "unknown"),
////                        bean.getVideoId(), System.currentTimeMillis());
////                //get natvie bitmap
////                if (timeCounter.isBitMapFileExist(fileName)) {
////                    nativeBitmap = fileUtil.readFile(fileName);
////
////                    timeCounter.setBitmapExsitFlag(true);
////                    //get counter
////                    SpUtil.getInstace().getInt(fileName, 0);
////                }
////                //get remote bitmap
////                HttpParams params = new HttpParams();
////                params.put("userMobileNumber", "13555770239");
////                params.put("videoId", "1233333");
////                SyncUtils.getInstance().params(params).callback(new OnSyncServerCallBack() {
////                    @Override
////                    public void onSyncServer(Object object) {
////
////                        data[0] = (BuyVideoIdBean) object;
////                        data[0].getData().getCounter();
////                        data[0].getData().getReverseData();
////
////                    }
////
//////                    @Override
//////                    public void onSyncServer(Response response) {
//////                        Log.d(TAG, "body"+response.body());
//////                    }
////
////                    /*String str1 = "abcd";
////                    byte[] bs1 = str1.getBytes();
////                    byte[] bs1 = {97,98,100};
////                    String s = new String(bs1);*/
////                }).build(SyncUtils.BUYVIDEOID);
//            }
//
//            @Override
//            public void onError(Response<AliVideoBean> response) {
//                loadingView.dismiss();
//                super.onError(response);
//            }
//        }).build();
//    }
//
//    private HashMap<String, String> getRequestBody(RecordVideoBean.ListBean bean) {
//        HashMap<String, String> map = new HashMap<>();
//        map.put("userId", SpUtil.getInstace().getString(Contants.USER_ID, null));
//        map.put("videoId", bean.getVideoId());
//        map.put("type", "1");
//        return map;
//    }
}
