package com.beanpodtech.allinone.adapter;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.SelectSubjectBean;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.request.RequestOptions;

import java.util.List;

public class TeachersAdapter extends RecyclerView.Adapter {
    private List<SelectSubjectBean.ListBean.TeacherListBean> list;
    private Context mContext;
    private LayoutInflater inflate;
    private RequestOptions requestOptions;
    private int totalNum;
    private OnTeacherItemClickListener onTeacherItemClickListener;

    public TeachersAdapter(List<SelectSubjectBean.ListBean.TeacherListBean> list, Context mContext, int totalNum) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
        this.totalNum = totalNum;
        requestOptions = new RequestOptions()
                .error(R.drawable.avatar_temp)
                .transform(new CircleCrop())
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .circleCrop();
    }

    public void setOnTeacherItemClickListener(OnTeacherItemClickListener onTeacherItemClickListener) {
        this.onTeacherItemClickListener = onTeacherItemClickListener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = null;
        if (totalNum == 1) {
            view = inflate.inflate(R.layout.item_teachers, parent, false);
        } else if (totalNum == 2) {
            view = inflate.inflate(R.layout.item_teachers_two, parent, false);
        } else if (totalNum == 3) {
            view = inflate.inflate(R.layout.item_teachers_three, parent, false);
        }

        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
        SelectSubjectBean.ListBean.TeacherListBean teacherListBean = null;
        switch (totalNum) {
            case 1:
                if (list != null && list.size() > 7) {
                    teacherListBean = list.get(position % list.size());
                } else {
                    teacherListBean = list.get(position);
                }
//                ((ViewHolder) holder).tvName.setText(teacherListBean.getTeacherName());
//                ((ViewHolder) holder).tvSubject.setText(teacherListBean.getTeacherType());
//                if (!isDestroy((Activity) mContext)) {
//                    Glide.with(this.mContext)
//                            .load(teacherListBean.getTeacherAvatar())
//                            .apply(requestOptions)
//                            .into(((ViewHolder) holder).ivAvatar);
//                }
                break;
            case 2:
                if (list != null && list.size() > 7) {
                    teacherListBean = list.get(position % list.size());
                } else {
                    teacherListBean = list.get(position);
                }
//                ((ViewHolder) holder).tvName.setText(teacherListBean.getTeacherName());
//                ((ViewHolder) holder).tvSubject.setText(teacherListBean.getTeacherType());
//                if (!isDestroy((Activity) mContext)) {
//                    Glide.with(this.mContext)
//                            .load(teacherListBean.getTeacherAvatar())
//                            .apply(requestOptions)
//                            .into(((ViewHolder) holder).ivAvatar);
//                }
                break;
            case 3:
                if (list != null && list.size() > 5) {
                    teacherListBean = list.get(position % list.size());
                } else {
                    teacherListBean = list.get(position);
                }

                break;
            default:
                break;
        }
        ((ViewHolder) holder).tvName.setText(teacherListBean.getTeacherName());
        ((ViewHolder) holder).tvSubject.setText(teacherListBean.getTeacherType());
        if (!isDestroy((Activity) mContext)) {
            Glide.with(this.mContext)
                    .load(teacherListBean.getTeacherAvatar())
                    .apply(requestOptions)
                    .into(((ViewHolder) holder).ivAvatar);
        }
        SelectSubjectBean.ListBean.TeacherListBean finalTeacherListBean = teacherListBean;
        ((ViewHolder) holder).ivAvatar.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onTeacherItemClickListener.onTeacherItemClick(finalTeacherListBean.getTeacherId(), finalTeacherListBean.getTeacherName());
            }
        });
    }

    /**
     * 判断Activity是否Destroy
     *
     * @param
     * @return
     */
    public boolean isDestroy(Activity mActivity) {
        if (mActivity == null || mActivity.isFinishing() || (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1 && mActivity.isDestroyed())) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int getItemCount() {
        switch (totalNum) {
//            case 1:
//                if (list != null && list.size() > 11) {
//                    return Integer.MAX_VALUE;
//                } else {
//                    return list.size();
//                }
            case 1:
                if (list != null && list.size() > 7) {
                    return Integer.MAX_VALUE;
                } else {
                    return list.size();
                }
            case 2:
                if (list != null && list.size() > 7) {
                    return Integer.MAX_VALUE;
                } else {
                    return list.size();
                }
            case 3:
                if (list != null && list.size() > 5) {
                    return Integer.MAX_VALUE;
                } else {
                    return list.size();
                }

        }
        return list.size();

    }

    //内部类，绑定控件
    class ViewHolder extends RecyclerView.ViewHolder {
        TextView tvName, tvSubject;
        ImageView ivAvatar;

        public ViewHolder(View itemView) {
            super(itemView);
            tvName = (TextView) itemView.findViewById(R.id.tv_name);
            tvSubject = (TextView) itemView.findViewById(R.id.tv_subject);
            ivAvatar = (ImageView) itemView.findViewById(R.id.iv_avatar);
        }
    }

    public interface OnTeacherItemClickListener {
        void onTeacherItemClick(String teacherId, String name);
    }
}
