package com.beanpodtech.allinone.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.TestQuestionBean;

import java.util.List;

public class TestQuestionAdapter extends RecyclerView.Adapter {
    private List<TestQuestionBean.ListBean> list;
    private Context mContext;
    private LayoutInflater inflate;

    public TestQuestionAdapter(List<TestQuestionBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = inflate.inflate(R.layout.item_testquestion, parent, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        ((ViewHolder) holder).tvName.setText(list.get(position).getTestQuestionName());
        ((ViewHolder) holder).ivSelect.setImageDrawable(list.get(position).isSelect() ? mContext.getResources().getDrawable(R.drawable.testquestion_select) : mContext.getResources().getDrawable(R.drawable.testquestion_unselect));
        ((ViewHolder) holder).ivSelect.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                for (int i = 0; i < list.size(); i++) {
                    list.get(i).setSelect(false);
                }
                list.get(position).setSelect(!list.get(position).isSelect());
                notifyDataSetChanged();
            }
        });
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    //内部类，绑定控件
    class ViewHolder extends RecyclerView.ViewHolder {
        TextView tvName;
        ImageView ivSelect;

        public ViewHolder(View itemView) {
            super(itemView);
            tvName = itemView.findViewById(R.id.tv_name);
            ivSelect = itemView.findViewById(R.id.iv_select);
        }
    }

}
