package com.beanpodtech.allinone.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.aliyun.svideo.common.utils.ToastUtils;
import com.beanpodtech.allinone.activity.AlivcPlayerActivity;
import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.FreeVideoBean;
import com.beanpodtech.allinone.bean.VideoBean;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.HttpUtils;
import com.beanpodtech.allinone.utils.OkGoBuilder;
import com.beanpodtech.allinone.utils.OkGoUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.beanpodtech.allinone.widget.LoadingView;
import com.beanpodtech.allinone.widget.RoundImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.google.gson.JsonObject;
import com.lzy.okgo.model.Response;

import java.util.List;

//import com.aliyun.solution.longvideo.activity.AlivcPlayerActivity;

public class VideoFreeAdapter extends RecyclerView.Adapter {
    private static final String TAG = "VideoAdapter";
    private List<VideoBean.ListBean> list;
    private Context mContext;
    private LayoutInflater inflate;
    private LoadingView loadingView;
    private RequestOptions requestOptions;

    public VideoFreeAdapter(List<VideoBean.ListBean> list, Context mContext) {
        this.list = list;
        this.mContext = mContext;
        inflate = LayoutInflater.from(mContext);
        loadingView = new LoadingView(mContext, R.style.CustomDialog);
        loadingView.setTitle(R.string.pleasewait);
        requestOptions = new RequestOptions()
                .error(R.drawable.temp_video_bg)
                .diskCacheStrategy(DiskCacheStrategy.ALL);
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        View view = inflate.inflate(R.layout.course_free, viewGroup, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
//        ((ViewHolder) holder).className.setText(list.get(position).getSubjectName());
        ((ViewHolder) holder).tvTitle.setText(list.get(position).getCoursesName());
        ((ViewHolder) holder).tvTotaltime.setText(list.get(position).getVideoDuration());
        ((ViewHolder) holder).ivPlan.setVisibility(View.GONE);
        Glide.with(this.mContext)
                .load(list.get(position).getCoverUrl())
                .apply(requestOptions)
                .into(((ViewHolder) holder).rivBg);
        holder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loadingView.show();
                getPlayAuth(list.get(position));
            }
        });
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    //内部类，绑定控件
    class ViewHolder extends RecyclerView.ViewHolder {
        TextView className;
        TextView tvTotaltime, tvTitle;
        RoundImageView rivBg;
        ImageView ivPlan;

        public ViewHolder(View itemView) {
            super(itemView);
            className = (TextView) itemView.findViewById(R.id.class_name);
            tvTotaltime = (TextView) itemView.findViewById(R.id.tv_totaltime);
            tvTitle = (TextView) itemView.findViewById(R.id.tv_title);
            rivBg = (RoundImageView) itemView.findViewById(R.id.riv_bg);
            ivPlan = itemView.findViewById(R.id.iv_plan);
        }
    }

    private void getPlayAuth(final VideoBean.ListBean bean) {
        // 202103  修改接口    video_id  userId  boxId
        OkGoBuilder.getInstance().url(UrlConfig.GETPlayAuthForFreeVideo).Builder((Activity) mContext).method(OkGoBuilder.PSOT).cls(FreeVideoBean.class).
                requestBody(HttpUtils.getRequestJson(getRequestBody(bean))).callback(new OkGoUtil<FreeVideoBean>(FreeVideoBean.class) {
            @Override
            public void onSuccess(Response<FreeVideoBean> response) {
                loadingView.dismiss();
                FreeVideoBean body = response.body();
                if (body != null) {
//                    if (!body.isBelongCurrent()) {
//                        ToastUtils.show(mContext, mContext.getString(R.string.currentvideo_notbelong));
//                        return;
//                    }
//                    if (!body.isAllowPlay()) {
//                        ToastUtils.show(mContext, mContext.getString(R.string.not_have_role_watch));
//                        return;
//                    }
                    if (body.getStatus() == -2) {
                        ToastUtils.show(mContext, mContext.getString(R.string.get_video_fail));
                    } else {
//                        AlivcPlayerActivity.startAlivcPlayerActivity(mContext, body, bean.getCourseId(), bean.getVideoId(), false, false, true);
                        AlivcPlayerActivity.startAlivcPlayerActivity(mContext, body.getVideo_url(), true);
                    }
                } else {
                    ToastUtils.show(mContext, R.string.neterror);
                }
            }

            @Override
            public void onError(Response<FreeVideoBean> response) {
                loadingView.dismiss();
                super.onError(response);
                ToastUtils.show(mContext, R.string.neterror);
            }
        }).build();
    }

    private JsonObject getRequestBody(VideoBean.ListBean bean) {

        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("userId", SpUtil.getInstace().getString(Contants.USER_ID, null));
        jsonObject.addProperty("video_id", bean.getVid());

        return jsonObject;
    }
}