package com.beanpodtech.allinone.application;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.provider.Settings;
import android.util.Log;

import androidx.multidex.MultiDex;

import com.alibaba.security.realidentity.RPConfig;
import com.alibaba.security.realidentity.RPVerify;
import com.aliyun.private_service.PrivateService;
import com.beanpodtech.allinone.BuildConfig;
import com.beanpodtech.allinone.utils.DeviceIdUtils;
import com.beanpodtech.allinone.utils.FileUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.bumptech.glide.Glide;
import com.lzy.okgo.OkGo;
import com.tencent.bugly.Bugly;
import com.tencent.bugly.beta.Beta;


import java.util.UUID;

import cn.eeo.classinsdk.ClassInSdkManager;
import cn.eeo.classinsdk.support.DeployEnv;

public class EduApplication extends Application {
    private static Context mContext;
    private Handler handler = new Handler();
    private String encryptedAppPath;
    /**
     * buyly的key
     */
//    private static final String BUGLY_KEY = "6fada77be7"; // 盒子 bugly
    private static final String BUGLY_KEY = "1fd6379f97"; // 一体机 bugly


    public String uuid;
    static EduApplication instance;

    public static EduApplication getInstance() {
        return instance;
    }


    @Override
    public void onCreate() {
        super.onCreate();
        mContext = this;
        instance = this;
//        try {
//            uuid = Settings.System.getString(getContentResolver(), Settings.System.ANDROID_ID);
//        } catch (Exception e) {
//            uuid = UUID.randomUUID().toString();
//        }
        uuid = "1sd1fgds2gr2fer1gd2f12gr5e";
        OkGo.getInstance().init(this);

        handler.postDelayed(() -> {
            Beta.autoInit = true;
            Beta.autoCheckUpgrade = true;
            Beta.upgradeCheckPeriod = 10 * 1000;
            Beta.initDelay = 1 * 1000;
            Beta.showInterruptedStrategy = true;
            Bugly.init(getContext(), BUGLY_KEY, true);

            initClassin();
        }, 3200);

        //初始化加密文件
        initAliYunEncrypted();

        //重启后退出登录
//        SpUtil.getInstace().clear();

        Glide.get(this).clearMemory();

      /*  new Timer().schedule(new TimerTask() {
            @Override
            public void run() {
                // 清除所有磁盘缓存(需要在子线程操作)
                Glide.get(EduApplication.this).clearDiskCache();
            }
        }, 10000);*/
        //初始化阿里人脸识别
        RPVerify.init(mContext);
        RPConfig.Builder configBuilder = new RPConfig.Builder()
                .setSkinInAssets(true);// 是否是内置皮肤。
        configBuilder.setSkinPath("");//// 设置皮肤路径。


    }

    int classinInitTimes = 0;

    private void initClassin() {
        classinInitTimes++;
        if (classinInitTimes > 2) return;

        DeployEnv mode = DeployEnv.DEVELOPMENT;

/*        if (BuildConfig.DEBUG) {
            mode = DeployEnv.DEVELOPMENT;
        } else {
            mode = DeployEnv.PRODUCTION;
        }*/

        try {
            ClassInSdkManager.init(this, "dxkajfalkdfaljfla", mode);
        } catch (Exception ignored) {
            handler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    initClassin();
                }
            }, 4500);
        }
    }

    /**
     * 加密文件
     */
    private void initAliYunEncrypted() {
        if (FileUtil.fileIsExists(mContext.getCacheDir().getAbsolutePath())) {
            encryptedAppPath = FileUtil.getFileAbsolutePath(mContext.getCacheDir().getAbsolutePath());
        } else {
            encryptedAppPath = FileUtil.getAssetsCacheFile(mContext, "encryptedApp.dat");
        }
        PrivateService.initService(getApplicationContext(), encryptedAppPath);
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install(this);
    }

    // 获取全局上下文
    public static Context getContext() {
        return mContext;
    }
}
