package com.beanpodtech.allinone.fragment;

import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.activity.FreetrialActivity;
import com.beanpodtech.allinone.activity.PlayvideoActivity;
import com.beanpodtech.allinone.bean.ClassTypeBean;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.HttpUtils;
import com.beanpodtech.allinone.utils.OkGoBuilder;
import com.beanpodtech.allinone.utils.OkGoUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.beanpodtech.allinone.widget.RoundImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.lzy.okgo.model.Response;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.List;

import okhttp3.RequestBody;

public class Class2Fragment extends Fragment {

    private RecyclerView mRecyclerView4;
    private HomeAdapter mAdapter;

    List<ClassTypeBean.SpecialBean> special;
    private RequestOptions requestOptions;

    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        final View view = inflater.inflate(R.layout.class_fragment2, container, false);
        requestOptions = new RequestOptions()
//                .skipMemoryCache(true)//跳过内存缓存
                .diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
        mRecyclerView4 = view.findViewById(R.id.class_recyclerview4);
        String userId = SpUtil.getInstace().getString(Contants.USER_ID, null);
        HashMap<String, String> map = new HashMap<>();
        map.put("userId", userId);
        final RequestBody body = HttpUtils.getRequestJson(map);
        OkGoBuilder.getInstance().url(UrlConfig.GETCLASSTYPELIST).method(OkGoBuilder.PSOT).cls(ClassTypeBean.class).Builder(getActivity()).requestBody(body).callback(new OkGoUtil<ClassTypeBean>(ClassTypeBean.class) {
            @Override
            public void onSuccess(Response<ClassTypeBean> response) {
                if (response.body() instanceof ClassTypeBean) {
                    ClassTypeBean body = response.body();

                    special = body.getSpecial();

                    initData(view, mRecyclerView4, special);
                }
            }
        }).build();

        return view;
    }

    protected void initData(View view, RecyclerView recyclerView, List date_list) {
        recyclerView.setAdapter(mAdapter = new HomeAdapter(date_list));
        recyclerView.setLayoutManager(new StaggeredGridLayoutManager(4,StaggeredGridLayoutManager.VERTICAL));
        recyclerView.setItemAnimator(new DefaultItemAnimator());
    }

    class HomeAdapter extends RecyclerView.Adapter {
        public List list;

        public String className;
        public String classId;
        public String Url;

        public HomeAdapter(List list) {
            this.list = list;
        }

        @RequiresApi(api = Build.VERSION_CODES.M)
        @NonNull
        @Override
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
            int layout = R.layout.item_class_one;
            if (list.size() == 4) {
                layout = R.layout.item_class_one;
            } else if (list.size() == 5) {
                layout = R.layout.item_class_two;
            }
            View view = LayoutInflater.from(viewGroup.getContext()).inflate(layout, viewGroup, false);
            ViewHolder holder = new ViewHolder(view);
            return holder;

        }

        @Override
        public void onBindViewHolder(@NonNull final RecyclerView.ViewHolder viewHolder, final int i) {
            final Object object = list.get(i);
            if (object instanceof ClassTypeBean.HighOneClassBean) {
                Url = ((ClassTypeBean.HighOneClassBean) object).getCoverUrl();
            } else if (object instanceof ClassTypeBean.HighTwoClassBean) {
                Url = ((ClassTypeBean.HighTwoClassBean) object).getCoverUrl();
            } else if (object instanceof ClassTypeBean.HightThreeClassBean) {
                Url = ((ClassTypeBean.HightThreeClassBean) object).getCoverUrl();
            } else if (object instanceof ClassTypeBean.SpecialBean) {
                Url = ((ClassTypeBean.SpecialBean) object).getCoverUrl();
            }
            Glide.with(getActivity()).load(Url).error(R.drawable.default_error_img).apply(requestOptions).into(((ViewHolder) viewHolder).imageView);
//            ((ViewHolder) viewHolder).imageView.setBackgroundResource(images[i]);
            viewHolder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (object instanceof ClassTypeBean.HighOneClassBean) {
                        className = ((ClassTypeBean.HighOneClassBean) object).getClassName();
                        classId = ((ClassTypeBean.HighOneClassBean) object).getClassId();
                    } else if (object instanceof ClassTypeBean.HighTwoClassBean) {
                        className = ((ClassTypeBean.HighTwoClassBean) object).getClassName();
                        classId = ((ClassTypeBean.HighTwoClassBean) object).getClassId();
                    } else if (object instanceof ClassTypeBean.HightThreeClassBean) {
                        className = ((ClassTypeBean.HightThreeClassBean) object).getClassName();
                        classId = ((ClassTypeBean.HightThreeClassBean) object).getClassId();
                    } else if (object instanceof ClassTypeBean.SpecialBean) {
                        className = ((ClassTypeBean.SpecialBean) object).getClassName();
                        classId = ((ClassTypeBean.SpecialBean) object).getClassId();
                    }

                    Bundle bundle = new Bundle();

                    if ("12".equals(classId)) { // 试听专区
                        bundle.putString(Contants.CLASS_NAME, "免费体验区");
                        FreetrialActivity.startActivity(getActivity(), bundle);
                    } else {
                        bundle.putCharSequence(Contants.CLASS_NAME, className);
                        bundle.putCharSequence(Contants.CLASS_ID, classId);
                        PlayvideoActivity.startActivity(getActivity(), bundle);
                    }

                }
            });
        }

        @Override
        public int getItemCount() {
            return list.size();
        }

        public class ViewHolder extends RecyclerView.ViewHolder {
            RoundImageView imageView;


            public ViewHolder(@NonNull View itemView) {
                super(itemView);
                imageView = itemView.findViewById(R.id.background);

            }
        }
    }

    private String initJson(String userId, String boxId) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("userId", userId);
            jsonObject.put("boxId", boxId);

        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }
}
