package com.beanpodtech.allinone.fragment;

import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.viewpager.widget.ViewPager;

import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.bean.TabItem;

import com.beanpodtech.allinone.adapter.ClassTypeAdapter;

import com.beanpodtech.allinone.widget.CustomTabLayout;
import com.flyco.tablayout.listener.CustomTabEntity;
import com.flyco.tablayout.listener.OnTabSelectListener;

import java.util.ArrayList;

public class ClassTypeFragment extends BaseFragment {
    private CustomTabLayout tabLayout;
    private ViewPager viewPager;
    @Override
    public int setLayout() {
        return R.layout.fragment_class_type;
    }

    @Override
    public void initView(View view) {
        tabLayout = view.findViewById(R.id.tab_layout);
        viewPager = view.findViewById(R.id.view_pager);

        ArrayList<CustomTabEntity> tabItems = new ArrayList<>();
        tabItems.add(new TabItem("常规课程", 0, 0));
        tabItems.add(new TabItem("特色课程", 0, 0));
        tabLayout.setCurTextMax(true);
        tabLayout.setTabData(tabItems);
        tabLayout.setOnTabSelectListener(new OnTabSelectListener() {
            @Override
            public void onTabSelect(int position) {
                viewPager.setCurrentItem(position);
            }

            @Override
            public void onTabReselect(int position) {

            }
        });
        ClassTypeAdapter adapter = new ClassTypeAdapter(getChildFragmentManager());
        adapter.setFragments(new Fragment[2]);
        viewPager.setAdapter(adapter);
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {
                tabLayout.setCurrentTab(position);
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

    }

    @Override
    public void initData() {

    }


}
