package com.beanpodtech.allinone.fragment;

import android.view.View;

import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.aliyun.svideo.common.utils.ToastUtils;
import com.beanpodtech.allinone.R;
import com.beanpodtech.allinone.adapter.FreeFilterAdapter;
import com.beanpodtech.allinone.adapter.VideoFreeAdapter;
import com.beanpodtech.allinone.bean.FreeFilterBean2;
import com.beanpodtech.allinone.bean.VideoBean;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.HttpUtils;
import com.beanpodtech.allinone.utils.OkGoBuilder;
import com.beanpodtech.allinone.utils.OkGoUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.beanpodtech.allinone.widget.LoadingView;
import com.beanpodtech.allinone.widget.flowlayout.TagFlowLayout;
import com.lzy.okgo.model.Response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/**
 * @Description: java类作用描述
 * @Author: 大魔王老杨
 * @Date: 4/22/21 10:19 AM
 */
public class FindFragment extends BaseFragment {
    private TagFlowLayout mTflLevel,mTflType,mTflSubject,mTflTeacher,mTflOutline;
    private RecyclerView mIdRecyclerview;
    private final static int TYPE_1 = 1;
    private final static int TYPE_2 = 2;
    private final static int TYPE_3 = 3;
    private final static int TYPE_4 = 4;
    private final static int TYPE_5 = 5;
    // 202103  1体系 2科目 3分类 4大纲 5老师
    private List<FreeFilterBean2.LevelBean> list1 = new ArrayList<>();
    private List<FreeFilterBean2.LevelBean.SubjectsBean> list2 = new ArrayList<>();
    private List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean> list3 = new ArrayList<>();
    private List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean> list4 = new ArrayList<>();
    private List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean.TeachersBean> list5 = new ArrayList<>();
    private FreeFilterAdapter adapter1;
    private FreeFilterAdapter adapter2;
    private FreeFilterAdapter adapter3;
    private FreeFilterAdapter adapter4;
    private FreeFilterAdapter adapter5;
    private String userId;
    private LoadingView loadingView;
    private VideoFreeAdapter mAdapter;
    private List<VideoBean.ListBean> totalList = new ArrayList<>();

    @Override
    public int setLayout() {
        return R.layout.fragment_find;
    }

    @Override
    public void initView(View view) {
        mTflLevel = view.findViewById(R.id.tfl_level);
        mTflType = view.findViewById(R.id.tfl_type);
        mTflSubject =view. findViewById(R.id.tfl_subject);
        mTflTeacher = view.findViewById(R.id.tfl_teacher);
        mTflOutline = view.findViewById(R.id.tfl_outline);
        mIdRecyclerview = view.findViewById(R.id.id_recyclerview);
        mIdRecyclerview.setLayoutManager(new GridLayoutManager(getActivity(), 5));
        mIdRecyclerview.setItemAnimator(new DefaultItemAnimator());
        loadingView = new LoadingView(getActivity(), R.style.CustomDialog);
        loadingView.setTitle(getResources().getString(R.string.waitloading));
    }

    @Override
    public void initData() {
        initListener();
        userId = SpUtil.getInstace().getString(Contants.USER_ID, null);
        adapter1 = new FreeFilterAdapter(list1, getLayoutInflater(), mTflLevel);
        mTflLevel.setAdapter(adapter1);
        adapter2 = new FreeFilterAdapter(list2, getLayoutInflater(), mTflType);
        mTflType.setAdapter(adapter2);
        adapter3 = new FreeFilterAdapter(list3, getLayoutInflater(), mTflSubject);
        mTflSubject.setAdapter(adapter3);
        adapter4 = new FreeFilterAdapter(list4, getLayoutInflater(), mTflTeacher);
        mTflTeacher.setAdapter(adapter4);
        adapter5 = new FreeFilterAdapter(list5, getLayoutInflater(), mTflOutline);
        mTflOutline.setAdapter(adapter5);
        mAdapter = new VideoFreeAdapter(totalList, getActivity());
        mIdRecyclerview.setAdapter(mAdapter);
        getFilterListFromNet();
    }
    private void getFilterListFromNet() {
        loadingView.show();
        HashMap<String, String> map = new HashMap<>();
        map.put("userId", userId);
        OkGoBuilder.getInstance().url(UrlConfig.FREEFILTER)
                .Builder(getActivity()).requestBody(HttpUtils.getRequestJson(map))
                .method(OkGoBuilder.PSOT).cls(FreeFilterBean2.class)
                .callback(new OkGoUtil<FreeFilterBean2>(FreeFilterBean2.class) {
                    @Override
                    public void onSuccess(Response<FreeFilterBean2> response) {

                        if (response.body().getLevel() != null) {
                            if (response.body() instanceof FreeFilterBean2) {
                                dealDataFromNet(response);
                                getRequestData();
                            }
                        } else {
                            list1.clear();
                            list2.clear();
                            list3.clear();
                            list4.clear();
                            list5.clear();
                            totalList.clear();
                            adapter1.notifyDataChanged();
                            adapter2.notifyDataChanged();
                            adapter3.notifyDataChanged();
                            adapter4.notifyDataChanged();
                            adapter5.notifyDataChanged();
                            mAdapter.notifyDataSetChanged();
                            loadingView.dismiss();
                        }
                    }

                    @Override
                    public void onError(Response<FreeFilterBean2> response) {
                        ToastUtils.show(getActivity(), getResources().getString(R.string.neterror));
                        loadingView.dismiss();
                        super.onError(response);
                    }
                }).build();
    }

    /**
     * @param response 请求回来response
     */
    private void dealDataFromNet(Response<FreeFilterBean2> response) {
        List<FreeFilterBean2.LevelBean> listTemp1;
        List<FreeFilterBean2.LevelBean.SubjectsBean> listTemp2;
        List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean> listTemp3;
        List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean> listTemp4;
        List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean.TeachersBean> listTemp5;
        try {
            FreeFilterBean2 body = response.body();
            if (body != null) {
                listTemp1 = body.getLevel();
            } else {
                listTemp1 = new ArrayList<>();
            }
            if (body.getLevel() != null && body.getLevel().size() != 0) {
                listTemp2 = body.getLevel().get(0).getSubjects();
            } else {
                listTemp2 = new ArrayList<>();
            }
            if (listTemp2 != null && listTemp2.size() != 0) {
                listTemp3 = body.getLevel().get(0).getSubjects().get(0).getTypes();
            } else {
                listTemp3 = new ArrayList<>();
            }
            if (listTemp3 != null && listTemp3.size() != 0) {
                listTemp4 = body.getLevel().get(0).getSubjects().get(0).getTypes().get(0).getOutLines();
            } else {
                listTemp4 = new ArrayList<>();
            }
            if (listTemp4 != null && listTemp4.size() != 0) {
                listTemp5 = body.getLevel().get(0).getSubjects().get(0).getTypes().get(0).getOutLines().get(0).getTeachers();
            } else {
                listTemp5 = new ArrayList<>();
            }
            if (listTemp1 != null) {
                this.list1.clear();
                this.list1.addAll(listTemp1);
            }
            if (listTemp2 != null) {
                this.list2.clear();
                this.list2.addAll(listTemp2);
            }
            if (listTemp3 != null) {
                this.list3.clear();
                this.list3.addAll(listTemp3);
            }
            if (listTemp4 != null) {
                this.list4.clear();
                this.list4.addAll(listTemp4);
            }
            if (listTemp5 != null) {
                this.list5.clear();
                this.list5.addAll(listTemp5);
            }
            adapter1.notifyDataChanged();
            adapter2.notifyDataChanged();
            adapter3.notifyDataChanged();
            adapter4.notifyDataChanged();
            adapter5.notifyDataChanged();
            adapter1.setSelectedList(0);
            adapter2.setSelectedList(0);
            adapter3.setSelectedList(0);
            adapter4.setSelectedList(0);
            adapter5.setSelectedList(0);
        } catch (NullPointerException e) {

        }

    }
    private void initListener() {
        mTflLevel.setOnTagClickListener((view, position, parent) -> {
            doFilter(TYPE_1, position);
            return true;
        });
        mTflType.setOnTagClickListener((view, position, parent) -> {
            doFilter(TYPE_2, position);
            return true;
        });
        mTflSubject.setOnTagClickListener((view, position, parent) -> {
            doFilter(TYPE_3, position);
            return true;
        });
        mTflTeacher.setOnTagClickListener((view, position, parent) -> {
            doFilter(TYPE_4, position);
            return true;
        });
        mTflOutline.setOnTagClickListener((view, position, parent) -> {
            doFilter(TYPE_5, position);
            return true;
        });
    }

    /**
     * @param clickType 点的哪一个分类  // 202103  1体系 2科目 3分类 4大纲 5老师
     * @param position  点的分类下的index
     */
    private void doFilter(int clickType, int position) {
        List<FreeFilterBean2.LevelBean.SubjectsBean> temp2 = null;
        List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean> temp3 = null;
        List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean> temp4 = null;
        List<FreeFilterBean2.LevelBean.SubjectsBean.TypesBean.OutLinesBean.TeachersBean> temp5 = null;
        switch (clickType) {
            case TYPE_1:
                temp2 = list1.get(position).getSubjects();
                list2.clear();
                if (temp2 != null) {
                    list2.addAll(temp2);
                }
                adapter2.notifyDataChanged();
                if (list2 != null && list2.size() != 0) {
                    temp3 = list2.get(0).getTypes();
                } else {
                    temp3 = new ArrayList<>();
                }
                list3.clear();
                if (temp3 != null) {
                    list3.addAll(temp3);
                }
                adapter3.notifyDataChanged();

                if (list3 != null && list3.size() != 0) {
                    temp4 = list3.get(0).getOutLines();
                } else {
                    temp4 = new ArrayList<>();
                }
                list4.clear();
                if (temp4 != null) {
                    list4.addAll(temp4);
                }
                adapter4.notifyDataChanged();
                if (list4 != null && list4.size() != 0) {
                    temp5 = list4.get(0).getTeachers();
                } else {
                    temp5 = new ArrayList<>();
                }
                list5.clear();
                if (temp5 != null) {
                    list5.addAll(temp5);
                }
                adapter5.notifyDataChanged();
                break;
            case TYPE_2:
                temp3 = list2.get(position).getTypes();
                list3.clear();
                if (temp3 != null) {
                    list3.addAll(temp3);
                }
                adapter3.notifyDataChanged();
                if (list3 != null && list3.size() != 0) {
                    temp4 = list3.get(0).getOutLines();
                } else {
                    temp4 = new ArrayList<>();
                }
                list4.clear();
                if (temp4 != null) {
                    list4.addAll(temp4);
                }
                adapter4.notifyDataChanged();
                if (list4 != null && list4.size() != 0) {
                    temp5 = list4.get(0).getTeachers();
                } else {
                    temp5 = new ArrayList<>();
                }
                list5.clear();
                if (temp5 != null) {
                    list5.addAll(temp5);
                }
                adapter5.notifyDataChanged();

                break;
            case TYPE_3:
                temp4 = list3.get(position).getOutLines();
                list4.clear();
                if (temp4 != null) {
                    list4.addAll(temp4);
                }
                adapter4.notifyDataChanged();
                if (list4 != null && list4.size() != 0) {
                    temp5 = list4.get(0).getTeachers();
                } else {
                    temp5 = new ArrayList<>();
                }
                list5.clear();
                if (temp5 != null) {
                    list5.addAll(temp5);
                }
                adapter5.notifyDataChanged();

                break;
            case TYPE_4:
                temp5 = list4.get(position).getTeachers();
                list5.clear();
                if (temp5 != null) {
                    list5.addAll(temp5);
                }
                adapter5.notifyDataChanged();
                break;
            default:
                break;
        }

        getRequestData();
    }

    /**
     * 每次筛选条件改变的时候封装视频列表接口需要的参数
     */
    private void getRequestData() {
        Iterator<Integer> integer1 = mTflLevel.getSelectedList().iterator();
        Iterator<Integer> integer2 = mTflType.getSelectedList().iterator();
        Iterator<Integer> integer3 = mTflSubject.getSelectedList().iterator();
        Iterator<Integer> integer4 = mTflTeacher.getSelectedList().iterator();
        Iterator<Integer> integer5 = mTflOutline.getSelectedList().iterator();
        String id1 = "";
        String id2 = "";
        String id3 = "";
        String id4 = "";
        String id5 = "";
        while (integer1.hasNext()) {
            Integer next = integer1.next();
            if (list1 != null && list1.size() != 0) {
                id1 = list1.get(next).getFilterLevelId();
            }
        }
        while (integer2.hasNext()) {
            Integer next = integer2.next();
            if (list2 != null && list2.size() != 0) {
                id2 = list2.get(next).getFilterSubjectId();
            }
        }
        while (integer3.hasNext()) {
            Integer next = integer3.next();
            if (list3 != null && list3.size() != 0) {
                id3 = list3.get(next).getFilterTypeId();
            }
        }

        while (integer4.hasNext()) {
            Integer next = integer4.next();
            if (list4 != null && list4.size() != 0) {
                id4 = list4.get(next).getFilterOutlineId();
            }
        }
        while (integer5.hasNext()) {
            Integer next = integer5.next();
            if (list5 != null && list5.size() != 0) {
                id5 = list5.get(next).getFilterTeacherId();
            }
        }
        getVideoListFromNet(id1, id2, id3, id4, id5);
    }

    /**
     * 获取视频列表
     */
    private void getVideoListFromNet(String str1, String str2, String str3, String str4, String str5) {
        loadingView.show();
        OkGoBuilder.getInstance().url(UrlConfig.FREEVIDEO).Builder(getActivity())
                .requestBody(HttpUtils.getRequestJson(initVideoListRequestJson(str1, str2, str3, str4, str5)))
                .cls(VideoBean.class).method(OkGoBuilder.PSOT)
                .callback(new OkGoUtil<VideoBean>(VideoBean.class) {
                    @Override
                    public void onSuccess(Response<VideoBean> response) {
                        loadingView.dismiss();
                        totalList.clear();
                        if (response.body() != null && response.body().getList() != null) {
                            if (response.body() instanceof VideoBean) {
                                VideoBean body = response.body();
                                List<VideoBean.ListBean> list = body.getList();
                                totalList.addAll(list);
                            }
                        }
                        mAdapter.notifyDataSetChanged();
                    }

                    @Override
                    public void onError(Response<VideoBean> response) {
                        loadingView.dismiss();
                        super.onError(response);
                    }

                    @Override
                    public void onFinish() {
                        super.onFinish();

                    }
                }).build();

    }

    /**
     * @param levelId   年级Id
     * @param subjectId 科目Id
     * @param teacherId 名师Id
     * @param outlineId 大纲Id
     * @return 返回处理好的请求requestBody
     */
    private HashMap<String, String> initVideoListRequestJson(String levelId, String subjectId, String typeId, String outlineId, String teacherId) {
        // 202103   1体系 2科目 3分类 4大纲 5老师
        HashMap<String, String> map = new HashMap<>();
        map.put("userId", userId);
        map.put("filterLevelId", levelId);
        map.put("filterSubjectId", subjectId);
        map.put("filterTypeId", typeId);
        map.put("filterOutlineId", outlineId);
        map.put("filterTeacherId", teacherId);
        return map;
    }
}
