package com.beanpodtech.allinone.fragment;

import android.content.Intent;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.aliyun.svideo.common.utils.ToastUtils;
import com.beanpodtech.allinone.R;

import com.beanpodtech.allinone.activity.FaceToFaceVideoActivity;
import com.beanpodtech.allinone.activity.StudyplanActivity;
import com.beanpodtech.allinone.adapter.HomePlanAdapter;
import com.beanpodtech.allinone.adapter.HomeRecordAdapter;
import com.beanpodtech.allinone.bean.GetPlanBean;
import com.beanpodtech.allinone.bean.RecordVideoBean;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.utils.Contants;
import com.beanpodtech.allinone.utils.HttpUtils;
import com.beanpodtech.allinone.utils.OkGoBuilder;
import com.beanpodtech.allinone.utils.OkGoUtil;
import com.beanpodtech.allinone.utils.SpUtil;
import com.beanpodtech.allinone.widget.calendar.model.CalendarDate;
import com.lzy.okgo.model.Response;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

/**
 * 新建的首页  测试sssss
 */
public class FirstFragment extends BaseFragment implements View.OnClickListener {

    private TextView userName;
    private ImageView aiClassIv;
    private ImageView studyPlanIv;
    private ImageView studyStateIv;
    private ImageView studyHelpIv;
    private RelativeLayout todayStudyPlanRl;
    private RelativeLayout myStudyRecordRl;
    private String userId;
    private List<RecordVideoBean.ListBean> listRecommend = new ArrayList<>(); //学习记录
    private List<GetPlanBean.ListBean> listPlay = new ArrayList<>(); //学习计划
    private HomeRecordAdapter homeRecordAdapter;
    private HomePlanAdapter homePlanAdapter;
    private RecyclerView recyclerView;
    private LinearLayout header; //学习记录  学习计划 的 header
    private long currentTime; //当日的学习安排
    private String SelectedTime;
    private TextView stateDes;
    private TextView headerOperate;
    private LinearLayout stateLl;
    String uuid;

    @Override
    public int setLayout() {
        return R.layout.fragment_first;
    }

    @Override
    public void initView(View view) {
        //右侧布局
        stateLl = view.findViewById(R.id.ll_state);

        //用户昵称
        userName = view.findViewById(R.id.username);
        //Ai课表
        aiClassIv = view.findViewById(R.id.ai_class);
        aiClassIv.setOnClickListener(this);

        //学习计划
        studyPlanIv = view.findViewById(R.id.study_plan);
        studyPlanIv.setOnClickListener(this);

        //学情报告
        studyStateIv = view.findViewById(R.id.study_state);
        studyStateIv.setOnClickListener(this);

        //升学助力
        studyHelpIv = view.findViewById(R.id.study_help);
        studyHelpIv.setOnClickListener(this);

        //今日学习安排
        todayStudyPlanRl = view.findViewById(R.id.today_study_plan);
        todayStudyPlanRl.setOnClickListener(this);

        //我的学习记录
        myStudyRecordRl = view.findViewById(R.id.my_study_record);
        myStudyRecordRl.setOnClickListener(this);

        //右侧描述
        stateDes = view.findViewById(R.id.tv_state_des);


        //recyclerView
        recyclerView = view.findViewById(R.id.first_rv);
        recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));

        header = view.findViewById(R.id.ll_header);
        headerOperate = header.findViewById(R.id.tv_operate_header);

        //学习记录的Adapter
        homeRecordAdapter = new HomeRecordAdapter(R.layout.item_home_study_record, listRecommend);
        //学习计划的Adapter
        homePlanAdapter = new HomePlanAdapter(R.layout.item_home_study_plan, listPlay);
    }


    /**
     * @param userId 用户Id
     * @return 返回处理好的请求requestBody
     */
    private HashMap<String, String> initRequestJson(String userId/*, String keyWord, String page, String number*/) {
        HashMap<String, String> map = new HashMap<>();
        map.put("userId", userId);
        return map;
    }

    @Override
    public void initData() {
        userName.setText("Hi," + SpUtil.getInstace().getString(Contants.USER_NICKNAME, "鸿文学子"));
        userId = SpUtil.getInstace().getString(Contants.USER_ID, null);
        if (TextUtils.isEmpty(userId)) return;



    }

    @Override
    public void onResume() {
        super.onResume();

        getRecommendVideo();  //学习记录
        getStudyPlan();  //今天的学习计划

    }

    //获取今日学习计划
    private void getStudyPlan() {


        //-----------先获取当前时间 -------------------------------
        CalendarDate currentDate = new CalendarDate();
        SelectedTime = currentDate.year + "-" + currentDate.month + "-" + currentDate.day;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            currentTime = sdf.parse(SelectedTime).getTime();
            currentTime = currentTime / 1000;
        } catch (ParseException e) {
            e.printStackTrace();
        }

        HashMap<String, String> p_map = new HashMap<>();
        p_map.put("userId", userId);
        p_map.put("date", currentTime + "");
        OkGoBuilder.getInstance().url(UrlConfig.STUDYPLAN).Builder(getActivity()).requestBody(HttpUtils.getRequestJson(p_map)).method(OkGoBuilder.PSOT).cls(GetPlanBean.class).callback(new OkGoUtil<GetPlanBean>(GetPlanBean.class) {
            @Override
            public void onSuccess(Response<GetPlanBean> response) {
                listPlay.clear();
                if (response.body() != null) {
                    GetPlanBean planBean = response.body();
                    List<GetPlanBean.ListBean> list = planBean.getList();

                    if (list != null && list.size() > 0) {

                        setHeaderType(false);
                        stateDes.setText("今日学习安排");
                        listPlay.addAll(list);
                        recyclerView.setAdapter(homePlanAdapter);
                        homeRecordAdapter.notifyDataSetChanged();
                        todayStudyPlanRl.setVisibility(View.VISIBLE);
                    } else {
                        todayStudyPlanRl.setVisibility(View.GONE);
                    }
                }

            }
        }).build();
    }


    //获取学习记录
    private void getRecommendVideo() {

        OkGoBuilder.getInstance().url(UrlConfig.STUDYRECORD).Builder(getActivity()).requestBody(HttpUtils.getRequestJson(initRequestJson(userId/*, keyWord, page + "", number + ""*/))).cls(RecordVideoBean.class).method(OkGoBuilder.PSOT).callback(new OkGoUtil<RecordVideoBean>(RecordVideoBean.class) {
            @Override
            public void onSuccess(Response<RecordVideoBean> response) {

                if (response.body() != null && response.body().getList() != null) {
                    if (response.body() instanceof RecordVideoBean) {
                        RecordVideoBean body = response.body();
                        List<RecordVideoBean.ListBean> list = body.getList();
                        listRecommend.clear();
                        if (list.size() > 0) {
                            setHeaderType(true);
                            stateDes.setText("我的学习记录");
                            listRecommend.addAll(list);
                            recyclerView.setAdapter(homeRecordAdapter);
                            homePlanAdapter.notifyDataSetChanged();
                            myStudyRecordRl.setVisibility(View.VISIBLE);

                        } else {

//                            myStudyRecordRl.setVisibility(View.GONE);

                        }
                    }
                }
            }

            @Override
            public void onError(Response<RecordVideoBean> response) {
                super.onError(response);
            }

            @Override
            public void onFinish() {
                super.onFinish();

            }
        }).build();


    }

    private void setHeaderType(boolean b) {
        if (b) {
            headerOperate.setVisibility(View.GONE);
        } else {
            headerOperate.setVisibility(View.VISIBLE);

        }
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {

            case R.id.ai_class: //Ai课表
                startActivity(new Intent(getActivity(), FaceToFaceVideoActivity.class));
                break;

            case R.id.study_plan: //学习计划
                startActivity(new Intent(getActivity(), StudyplanActivity.class));
                break;

            case R.id.study_state: //学情报告
                ToastUtils.show(getContext(), "功能开发中");
                break;

            case R.id.study_help: //升学助力
                ToastUtils.show(getContext(), "未开发");
                break;

            case R.id.my_study_record: //我的学习记录
                if (stateLl.getVisibility() == View.GONE) stateLl.setVisibility(View.VISIBLE);
                getRecommendVideo();
                break;

            case R.id.today_study_plan: //今日学习安排
                if (stateLl.getVisibility() == View.GONE) stateLl.setVisibility(View.VISIBLE);
                getStudyPlan();
                break;
            default:
                break;

        }
    }


}
