package com.beanpodtech.allinone.retrofit;


import com.beanpodtech.allinone.bean.BaseResponse;
import com.beanpodtech.allinone.bean.DescribeVerifyBean;
import com.beanpodtech.allinone.bean.VerifyTokenBean;


import java.util.Map;

import io.reactivex.Observable;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

/**
 * @Description: 接口管理
 * @Author: 大魔王老杨
 * @Date: 4/12/21 5:35 PM
 */
public interface APIService {

    @POST("faceReco/DescribeVerifyResult")
    Observable<BaseResponse<DescribeVerifyBean>> getDescribeVerifyResult(@Body Map<String, Object> map);

    @POST("faceReco/DescribeVerifyToken")
    Observable<BaseResponse<VerifyTokenBean>> getVerifyToken(@Body Map<String, Object> map);

    @POST("faceReco/updateFaceUrl")
    Observable<BaseResponse<VerifyTokenBean>> updateFaceUrl(@Body Map<String, Object> map);
}
