package com.beanpodtech.allinone.retrofit;

/**
 * @Description: java类作用描述
 * @Author: 大魔王老杨
 * @Date: 4/12/21 5:07 PM
 */

import android.util.Log;

import com.beanpodtech.allinone.bean.BaseResponse;
import com.beanpodtech.allinone.utils.Contants;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

/**
 * @Description: Retrofit底层数据处理
 * @Author: 大魔王老杨
 * @Date: 4/12/21 5:35 PM
 */
public abstract class BaseObserver<T> implements Observer<BaseResponse<T>> {
    private static final String TAG = "BaseObserver";

    @Override
    public void onSubscribe(Disposable d) {
        Log.e(TAG, "onSubscribe: ");
    }

    @Override
    public void onNext(BaseResponse<T> response) {
        //在这边对 基础数据 进行统一处理
        Log.d("code", "onNext: code" + response.getCode());
        if (response.getCode() == Contants.KEY_SUCCESS) {
            onSuccess(response.getData());
        } else {
            onFailure(null, response.getMsg());
        }
    }

    @Override
    public void onError(Throwable e) {
        onFailure(e, RxExceptionUtil.exceptionHandler(e));
    }

    @Override
    public void onComplete() {
        Log.e(TAG, "onComplete: ");
    }

    public abstract void onSuccess(T data);

    public abstract void onFailure(Throwable e, String errorMsg);
}
