package com.beanpodtech.allinone.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.view.Window;

import com.beanpodtech.allinone.R;
import com.lzy.okgo.model.Response;
import com.lzy.okgo.request.base.Request;

public class DialogCallback<T> extends OkGoUtil<T> {
    private ProgressDialog mProgressDialog;

    public DialogCallback(Activity activity, Class<T> tClass) {
        super(tClass);
        initDialog(activity);
    }


    private void initDialog(Activity activity) {
        mProgressDialog = new ProgressDialog(activity, R.style.AppTheme);

        mProgressDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        mProgressDialog.setCanceledOnTouchOutside(false);
        mProgressDialog.setProgressStyle(ProgressDialog.STYLE_SPINNER);
        mProgressDialog.setMessage("请稍后");
    }

    @Override
    public void onStart(Request<T, ? extends Request> request) {
        if (mProgressDialog != null && !mProgressDialog.isShowing()) {
            mProgressDialog.show();
        }

    }

    @Override
    public void onFinish() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.dismiss();
        }
    }

    @Override
    public void onSuccess(Response<T> response) {

    }
}
