package com.beanpodtech.allinone.utils;

import android.util.Log;

import com.beanpodtech.allinone.BuildConfig;
import com.google.gson.Gson;
import com.google.gson.JsonObject;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import okhttp3.MediaType;
import okhttp3.RequestBody;

public class HttpUtils {
    /**
     * @param map 需要传的参数  map key为参数名   value为参数
     * @return 返回json字符串
     */
    public static RequestBody getRequestJson(HashMap<String, String> map) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("boxId", BoxUtil.getDeviceSN());
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                String key = (String) entry.getKey();
                String value = (String) entry.getValue();
                jsonObject.put(key, value);
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        if (BuildConfig.DEBUG) {
            Log.d("BOX===", "=====RequestBody " + jsonObject.toString());
        }
        RequestBody requestBody = RequestBody.create(jsonObject.toString(),MediaType.parse("application/json;charset=utf-8"));
        return requestBody;
    }

    /**
     * @return 返回json字符串
     */
    public static RequestBody getRequestJson(JsonObject jsonObject) {

        Gson gson = new Gson();
        jsonObject.addProperty("boxId", BoxUtil.getDeviceSN());

        String s = gson.toJson(jsonObject);
        RequestBody requestBody = RequestBody.create(s, MediaType.parse("application/json;charset=utf-8"));

        if (BuildConfig.DEBUG) {
            Log.d("BOX===", "=====RequestBody " + s);
        }
        return requestBody;
    }

}
