package com.beanpodtech.allinone.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

/**
 * 作者：jiahairan on 2020/12/4 08:54
 */
public class MyDividerItemDecoration extends RecyclerView.ItemDecoration {

    private Drawable mDivider;

    /**
     * Custom divider will be used
     */
    public MyDividerItemDecoration(Context context, int resId) {
        mDivider = ContextCompat.getDrawable (context, resId);
    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets (outRect, view, parent, state);
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager ();
        //因为绘制了顶部分割线，因此需要将第一行的item下移相应的距离        //这里要注意，判断该RecycleView是什么布局，如果是竖直方向上的线性布局（水平方向上的这里没有考虑）        //，那么需要让第一个Item下移，移动的距离是分割线的高度，因为分割线会占据Item的空间        //如果是网格布局，那么需要把第一行的所有Item都下移相应的高度
        if (layoutManager instanceof LinearLayoutManager) {
            if (parent.getChildAdapterPosition (view) >= 0) {
                outRect.set (0, mDivider.getIntrinsicHeight (), 0, 0);
            }
        }
        if (layoutManager instanceof GridLayoutManager) {
            if (parent.getChildAdapterPosition (view) >= 0 && parent.getChildAdapterPosition (view) < getSpanCount (parent)) {
                outRect.set (0, mDivider.getIntrinsicHeight (), 0, 0);
            }
        }
    }

    @Override
    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {









        
        int left = 0;
        int right = parent.getWidth ();
        if (parent.getChildCount () == 0) return;
        View child = parent.getChildAt (0);

        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams) child.getLayoutParams ();

        //不可以直接设置top = 0；因为这样的话分隔线就不会跟着移动，因为top = 0,是绝对位置，        //所以应该设置为子view的相对位置
        //这样才可以跟着滑动。        //child的顶部坐标，减去设置的margin_top的值，再减去child为了给分割线腾出空间所下滑的高度，        //这样分割线才会在顶部
        int top = child.getTop () - params.topMargin - mDivider.getIntrinsicHeight ();
        int bottom;
        bottom = top + mDivider.getIntrinsicHeight ();
        mDivider.setBounds (left, top, right, bottom);
        mDivider.draw (c);
    }

    private int getSpanCount(RecyclerView parent) {
        // 列数
        int spanCount = -1;
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager ();
        if (layoutManager instanceof GridLayoutManager) {
            spanCount = ((GridLayoutManager) layoutManager).getSpanCount ();
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            spanCount = ((StaggeredGridLayoutManager) layoutManager)
                    .getSpanCount ();
        } else if (layoutManager instanceof LinearLayoutManager) {
            spanCount = layoutManager.getItemCount ();
        }
        return spanCount;
    }
}
