package com.beanpodtech.allinone.utils;

import com.aliyun.svideo.common.utils.ToastUtils;
import com.beanpodtech.allinone.BuildConfig;
import com.beanpodtech.allinone.application.EduApplication;
import com.beanpodtech.allinone.bean.AnycPlayingTimeBean;
import com.beanpodtech.allinone.bean.BaseRequestBean;
import com.beanpodtech.allinone.bean.BuyVideoIdBean;
import com.beanpodtech.allinone.bean.ServiceTimeBean;
import com.beanpodtech.allinone.http.UrlConfig;
import com.beanpodtech.allinone.interfaces.OnSyncServerCallBack;
import com.lzy.okgo.OkGo;
import com.lzy.okgo.model.HttpParams;
import com.lzy.okgo.model.Response;

import okhttp3.RequestBody;

/**
 *
 */
public class SyncUtils {


    /**
     * 同步服务器时间
     */
    public static final int SERVICETIME = 1;

    /**
     * 修改或添加
     */
    public static final int ADDORUPDATE = 2;

    /**
     * 查询
     */
    public static final int BUYVIDEOID = 3;

    /**
     * 60S向后台发送一次播放时间
     */
    public static final int SENDPLAYINGTIME = 4;
//    private Activity activity;
    /**
     * 参数
     */
    private HttpParams params;
    private RequestBody body;
    /**
     * 回调
     */
    private OnSyncServerCallBack listener;
    /**
     * 单列模式
     **/
    private static SyncUtils syncUtils = null;

    /**
     * 构造函数私有化
     **/
    private SyncUtils() {
    }

    /**
     * 公有的静态函数，对外暴露获取单例对象的接口
     **/
//    public static SyncUtils getInstance() {
//        if (syncUtils == null) {
//            synchronized (SyncUtils.class) {
//                if (syncUtils == null) {
//                    syncUtils = new SyncUtils();
//                }
//            }
//        }
//        return syncUtils;
//    }

    /**
     * 类级的内部类，也就是静态的成员式内部类，该内部类的实例与外部类的实例
     * 没有绑定关系，而且只有被调用到才会装载，从而实现了延迟加载
     */
    private static class SingletonHolder {
        /**
         * 静态初始化器，由JVM来保证线程安全
         */
        private static SyncUtils instance = new SyncUtils();
    }

//    /**
//     * 私有化构造方法
//     */
//    private SyncUtils() {
//    }

    public static SyncUtils getInstance() {
        return new SyncUtils();
    }

    public SyncUtils params(HttpParams params) {
        this.params = params;
        return this;
    }

    public SyncUtils requestBody(RequestBody body) {
        this.body = body;
        return this;
    }

    public SyncUtils callback(OnSyncServerCallBack listener) {
        this.listener = listener;
        return this;
    }


    public SyncUtils build(int type) {
        switch (type) {
            case SERVICETIME:
                serviceTime();
                break;
            case ADDORUPDATE:
                addOrUpDate();
                break;
            case BUYVIDEOID:
                buyVideoid();
                break;
            case SENDPLAYINGTIME:
                sendPlayingTime();
                break;

        }
        return this;
    }

    /**
     * 查询
     */
    private void buyVideoid() {
        OkGo.getInstance()
                // 请求方式和请求url
                .<BuyVideoIdBean>post(UrlConfig.BUYVIDEOID)
                .upRequestBody(body)
                // 请求的 tag, 主要用于取消对应的请求
                .tag(this)
                // 设置当前请求的缓存key,建议每个不同功能的请求设置一个
//                .cacheKey("cacheKey")
                // 缓存模式，详细请看缓存介绍
//                .cacheMode(CacheMode.DEFAULT)
                .execute(new OkGoUtil<BuyVideoIdBean>(BuyVideoIdBean.class) {
                    @Override
                    public void onSuccess(Response<BuyVideoIdBean> response) {
                        if (response.body() != null) {
                            listener.onSyncServer(response.body());
                        }
                    }

                    @Override
                    public void onError(Response<BuyVideoIdBean> response) {
                        listener.onSyncServer(response.body());
                        super.onError(response);
                    }
                });
    }

    /**
     * 插入或修改
     */
    private void addOrUpDate() {
        OkGo.getInstance()
                // 请求方式和请求url
                .<BaseRequestBean>post(UrlConfig.ADDORUPDATE)
                .upRequestBody(body)
                // 请求的 tag, 主要用于取消对应的请求
                .tag(this)
                // 设置当前请求的缓存key,建议每个不同功能的请求设置一个
//                .cacheKey("cacheKey")
                // 缓存模式，详细请看缓存介绍
//                .cacheMode(CacheMode.DEFAULT)
                .execute(new OkGoUtil<BaseRequestBean>(BaseRequestBean.class) {
                    @Override
                    public void onSuccess(Response<BaseRequestBean> response) {
                        if (response.body() != null) {
                            listener.onSyncServer(response.body());
                        }
                    }

                    @Override
                    public void onError(Response<BaseRequestBean> response) {
                        listener.onSyncServer(response.body());
                        super.onError(response);
                    }
                });
    }

    /**
     * 同步时间
     */
    private void serviceTime() {
        OkGo.getInstance()
                // 请求方式和请求url
                .<ServiceTimeBean>post(UrlConfig.SERVICETIME)
                // 请求的 tag, 主要用于取消对应的请求
                .tag(this)
                // 设置当前请求的缓存key,建议每个不同功能的请求设置一个
//                .cacheKey("cacheKey")
                // 缓存模式，详细请看缓存介绍
//                .cacheMode(CacheMode.DEFAULT)
                .execute(new OkGoUtil<ServiceTimeBean>(ServiceTimeBean.class) {
                    @Override
                    public void onSuccess(Response<ServiceTimeBean> response) {
                        if (response.body() != null) {
                            listener.onSyncServer(response.body());
                        }
                    }

                    @Override
                    public void onError(Response<ServiceTimeBean> response) {
                        listener.onSyncServer(response.body());
                        super.onError(response);
                    }
                });
    }

    private void sendPlayingTime() {
        OkGo.getInstance()
                // 请求方式和请求url
                .<AnycPlayingTimeBean>post(UrlConfig.SYNC_PLAYINGTIME)
                .upRequestBody(body)
                // 请求的 tag, 主要用于取消对应的请求
                .tag(this)
                // 设置当前请求的缓存key,建议每个不同功能的请求设置一个
//                .cacheKey("cacheKey")
                // 缓存模式，详细请看缓存介绍
//                .cacheMode(CacheMode.DEFAULT)
                .execute(new OkGoUtil<AnycPlayingTimeBean>(AnycPlayingTimeBean.class) {
                    @Override
                    public void onSuccess(Response<AnycPlayingTimeBean> response) {

//                        if (BuildConfig.DEBUG) {
//                            Log.d("BOX===", response.code() +  " " + new Gson().toJson(response.body()));
//                        }

                        if (response.body() != null) {
                            listener.onSyncServer(response.body());
                        } else {
                            ToastUtils.show(EduApplication.getContext(), "网络异常");
                        }
                    }

                    @Override
                    public void onError(Response<AnycPlayingTimeBean> response) {
                        listener.onSyncServer(response.body());
//                        if (BuildConfig.DEBUG) {
//                            Log.d("BOX===", response.code() + " " + new Gson().toJson(response.body()));
//                        }
                        super.onError(response);
                    }
                });
    }
}
