package com.beanpodtech.allinone.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;

import com.beanpodtech.allinone.R;


/**
 * Created by YangShengLong on 2018/7/12 0012.
 */

public class BadgeRadioButton extends DrawableCenterRadioButton {

    /**
     * 字体高度
     */
    private float mFontHeight;
    /**
     * 字体宽度
     */
    private float mFontWidth;
    /**
     * 位图集合
     */
    private Drawable[] mDrawables;
    /**
     * 位图
     */
    private Drawable mDrawableBackground;
    /**
     * 背景画笔
     */
    private Paint mBadgeBackgroundPaint;
    /**
     * 数字画笔
     */
    private Paint mBadgeTextPaint;
    /**
     * 数字字体大小 默认8sp
     */
    private float mBadgeTextSize;
    /**
     * 内边距 默认4dp
     */
    private int mBadgePadding;
    /**
     * x偏移量
     */
    private int mBadgeOffX;
    /**
     * Y偏移量
     */
    private int mBadgeOffY;
    /**
     * 数字文本
     */
    private String mBadgeText;
    /**
     * 是否存在阴影 默认存在
     */
    private boolean mBadgeShowShadow;
    /**
     * 背景颜色 默认红色
     */
    private int mBadgeColorBackground;
    /**
     * 字体颜色 默认白色
     */
    private int mBadgeColorBadgeText;
    /**
     * 是否截取数字
     */
    private boolean mBadgeExact;
    /**
     * 背景矩形
     */
    private RectF mBadgeBackgroundRect;

    public BadgeRadioButton(Context context) {
        super(context);
        init();
    }

    public BadgeRadioButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public BadgeRadioButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);

        if (null != mDrawableBackground && null != mBadgeText) {
            showShadowImpl(mBadgeShowShadow, mBadgeBackgroundPaint);
            float maxPadding = getOffSize();
            if (mBadgePadding > maxPadding) {
                mBadgeOffY = (int) (mBadgePadding - maxPadding);
            }
            if (mBadgeText.length() == 0) {
                canvas.drawCircle((getWidth() + mDrawableBackground.getIntrinsicWidth()) / 2 + mBadgeOffX, mFontHeight / 2 + mBadgeOffY, mFontHeight / 2 + mBadgePadding, mBadgeBackgroundPaint);
            } else if (mBadgeText.length() <= 1) {
                canvas.drawCircle((getWidth() + mDrawableBackground.getIntrinsicWidth()) / 2 + mBadgeOffX, mFontHeight / 2 + mBadgeOffY, mFontHeight / 2 + mBadgePadding, mBadgeBackgroundPaint);
            } else {
                mBadgeBackgroundRect.left = (getWidth() + mDrawableBackground.getIntrinsicWidth()) / 2 - mFontWidth / 2 - mBadgePadding + mBadgeOffX;
                mBadgeBackgroundRect.right = (getWidth() + mDrawableBackground.getIntrinsicWidth()) / 2 + mFontWidth / 2 + mBadgePadding + mBadgeOffX;
                mBadgeBackgroundRect.top = -mBadgePadding + mBadgeOffY;
                mBadgeBackgroundRect.bottom = mFontHeight + mBadgePadding + mBadgeOffY;
                canvas.drawRoundRect(mBadgeBackgroundRect, mFontHeight / 2 + mBadgePadding, mFontHeight / 2 + mBadgePadding, mBadgeBackgroundPaint);
            }
            canvas.drawText(mBadgeText, (getWidth() + mDrawableBackground.getIntrinsicWidth()) / 2 - mFontWidth / 2 + mBadgeOffX, mFontHeight + mBadgeOffY, mBadgeTextPaint);
        }
    }

    /**
     * 设置是否显示小红点
     */
    public BadgeRadioButton setIsRead(boolean isRead) {
        if (!isRead) {
            mBadgeText = String.valueOf(1);
            measureText();
        } else {
            mBadgeText = null;
        }
        invalidate();
        return this;
    }

    /**
     * 测量文本高度和宽度
     */
    private void measureText() {
        mFontHeight = Math.abs(mBadgeTextPaint.getFontMetrics().descent + mBadgeTextPaint.getFontMetrics().ascent);
        mFontWidth = mBadgeTextPaint.measureText(mBadgeText);
    }

    /**
     * 为画笔设置阴影
     *
     * @param showShadow           是否显示
     * @param badgeBackgroundPaint 画笔
     */
    private void showShadowImpl(boolean showShadow, Paint badgeBackgroundPaint) {
        int x = dp2px(1);
        int y = dp2px(1.5f);
        badgeBackgroundPaint.setShadowLayer(showShadow ? dp2px(2f) : 0, x, y, 0x33000000);
    }

    @Override
    void init() {
        super.init();
        setLayerType(View.LAYER_TYPE_SOFTWARE, null);

        mBadgeTextSize = dp2px(1);
        mBadgePadding = dp2px(3);
        mBadgeShowShadow = true;
        mBadgeColorBackground = getResources().getColor(R.color.main_color);
        mBadgeColorBadgeText = getResources().getColor(R.color.main_color);
        mBadgeOffX = 0;
        mBadgeOffY = 0;
        mFontWidth = 0;
        mFontHeight = 0;
        mBadgeBackgroundRect = new RectF(0, 0, 0, 0);

        //目前只支持drawableTop的RadioButton
        mDrawables = getCompoundDrawables();
        if (null != mDrawables[1]) {
            mDrawableBackground = mDrawables[1];
        }
        /* 理论上可以支持drawableRight，但是没测试
       else if (null != mDrawables[2]) {
            mDrawableBackground = mDrawables[2];
        }*/

        mBadgeTextPaint = new TextPaint();
        mBadgeTextPaint.setAntiAlias(true);
        mBadgeTextPaint.setSubpixelText(true);
        mBadgeTextPaint.setFakeBoldText(true);
        mBadgeTextPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        mBadgeTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        mBadgeTextPaint.setDither(true);
        mBadgeTextPaint.setColor(mBadgeColorBadgeText);
        mBadgeTextPaint.setTextSize(mBadgeTextSize);

        mBadgeBackgroundPaint = new Paint();
        mBadgeBackgroundPaint.setAntiAlias(true);
        mBadgeBackgroundPaint.setStyle(Paint.Style.FILL);
        mBadgeBackgroundPaint.setDither(true);
        mBadgeBackgroundPaint.setColor(mBadgeColorBackground);
        showShadowImpl(mBadgeShowShadow, mBadgeBackgroundPaint);
    }


    /**
     * dp转px
     *
     * @param dpValue dp值
     * @return px值
     */
    public int dp2px(float dpValue) {
        final float scale = getContext().getResources().getDisplayMetrics().density;
        return (int) (dpValue * scale + 0.5f);
    }


}
