package com.beanpodtech.allinone.widget;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.view.WindowManager;
import android.widget.TextView;

import com.beanpodtech.allinone.R;

public class LoadingView extends ProgressDialog {

    private TextView tv_load_dialog;
    private String title;

    public LoadingView(Context context) {
        super(context);
    }

    public LoadingView(Context context, int theme) {
        super(context, theme);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        init(getContext());
    }

    private void init(Context context) {
        setCancelable(true);
        setCanceledOnTouchOutside(false);

        setContentView(R.layout.loading);//loading的xml文件
        tv_load_dialog = findViewById(R.id.tv_load_dialog);
        tv_load_dialog.setText(title);
        WindowManager.LayoutParams params = getWindow().getAttributes();
        params.width = WindowManager.LayoutParams.WRAP_CONTENT;
        params.height = WindowManager.LayoutParams.WRAP_CONTENT;
        getWindow().setAttributes(params);
    }

    @Override
    public void show() {//开启
        if (!isShowing()) {
            try {
                super.show();
            } catch (Exception ignored) {
            }
        }
    }

    @Override
    public void dismiss() {//关闭
        try {
            super.dismiss();
        } catch (IllegalArgumentException ignored) {
        }
    }
}
